/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.common;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ali.Utils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.manager.PluginManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class GenericUtils {
    private static final ResourceLocation TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int WIDGET_SIZE = 36;

    public static void renderEntity(Entity entity, Rect bounds, int fullWidth, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        PoseStack poseStack = guiGraphics.pose();
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)poseStack.last().pose());
        Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f mvpMatrix = projectionMatrix.mul((Matrix4fc)modelViewMatrix);
        Vector4f topLeftWorld = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        Vector4f topLeftClip = mvpMatrix.transform(topLeftWorld);
        Vector4f topLeftNDC = new Vector4f(topLeftClip.x / topLeftClip.w, topLeftClip.y / topLeftClip.w, 0.0f, 1.0f);
        int screenX = Math.round((topLeftNDC.x + 1.0f) / 2.0f * (float)window.getGuiScaledWidth());
        int screenY = Math.round((1.0f - topLeftNDC.y) / 2.0f * (float)window.getGuiScaledHeight());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            guiGraphics.pose().pushPose();
            guiGraphics.blit(RenderType::guiTextured, TEXTURE_LOC, bounds.x(), bounds.y(), 0.0f, 36.0f, bounds.width(), bounds.height(), 36, 36, 256, 256);
            guiGraphics.enableScissor(screenX + bounds.x() + 1, screenY + bounds.y() + 1, screenX + bounds.right() - 1, screenY + bounds.bottom() - 1);
            EntityDimensions dimensions = entity.getType().getDimensions();
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(-screenX + bounds.x()), (int)(-screenY + bounds.y()), (int)(screenX + bounds.right()), (int)(screenY + bounds.bottom()), (int)((int)Math.min(20.0f / dimensions.height(), 20.0f / dimensions.width())), (float)0.0625f, (float)((float)mouseX - (float)fullWidth / 2.0f), (float)mouseY, (LivingEntity)livingEntity);
            guiGraphics.disableScissor();
            guiGraphics.pose().popPose();
        }
    }

    @NotNull
    public static Map<ResourceKey<LootTable>, LootTable> getLootTables() {
        return new HashMap<ResourceKey<LootTable>, LootTable>(PluginManager.CLIENT_REGISTRY.getLootTables());
    }

    @NotNull
    public static List<Item> getItems(ResourceKey<LootTable> location) {
        return PluginManager.CLIENT_REGISTRY.getItems(location);
    }
}

