/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.rei;

import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.rei.ReiBaseCategory;
import com.yanny.ali.compatibility.rei.ReiEntityDisplay;
import com.yanny.ali.registries.LootCategory;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;

public class ReiEntityCategory
extends ReiBaseCategory<ReiEntityDisplay, Entity> {
    private final CategoryIdentifier<ReiEntityDisplay> identifier;
    private final Component title;
    private final ItemStack icon;

    public ReiEntityCategory(CategoryIdentifier<ReiEntityDisplay> identifier, Component title, LootCategory<Entity> lootCategory) {
        super(lootCategory);
        this.identifier = identifier;
        this.title = title;
        this.icon = lootCategory.getIcon();
    }

    @Override
    public List<Widget> setupDisplay(ReiEntityDisplay display, Rectangle bounds) {
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        int WIDGET_SIZE = 36;
        Rect rect = new Rect(0, 0, WIDGET_SIZE, WIDGET_SIZE);
        SpawnEggItem spawnEgg = SpawnEggItem.byId((EntityType)display.getEntity().getType());
        Rectangle entityRect = new Rectangle(bounds.getCenterX() - 18, bounds.getY() + 14, 36, 48);
        widgets.add((Widget)Widgets.createCategoryBase((Rectangle)bounds));
        widgets.addAll(this.getBaseWidget(display, bounds, 0, 48));
        if (spawnEgg != null) {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 4, bounds.getY() + 4)).entry(EntryStacks.of((ItemLike)spawnEgg)).markInput());
        }
        widgets.add((Widget)Widgets.wrapRenderer((Rectangle)entityRect, (graphics, bounds1, mouseX, mouseY, delta) -> {
            graphics.pose().pushPose();
            graphics.pose().translate((float)bounds1.getX(), (float)bounds1.getY(), 0.0f);
            GenericUtils.renderEntity(display.getEntity(), rect, 162, graphics, mouseX - bounds.getX(), mouseY - bounds.getY());
            graphics.pose().popPose();
        }));
        widgets.add((Widget)Widgets.wrapRenderer((Rectangle)new Rectangle(bounds.getCenterX() - Minecraft.getInstance().font.width((FormattedText)display.getEntity().getDisplayName()) / 2, bounds.getY() + 4, bounds.getWidth(), 8), (graphics, bounds1, mouseX, mouseY, delta) -> {
            graphics.pose().pushPose();
            graphics.pose().translate((float)bounds1.getX(), (float)bounds1.getY(), 0.0f);
            graphics.drawString(Minecraft.getInstance().font, display.getEntity().getDisplayName(), 0, 0, 0, false);
            graphics.pose().popPose();
        }));
        widgets.add(Widgets.createTooltip((Rectangle)entityRect, (Component[])new Component[]{display.getEntity().getDisplayName()}));
        return widgets;
    }

    public CategoryIdentifier<ReiEntityDisplay> getCategoryIdentifier() {
        return this.identifier;
    }

    public Component getTitle() {
        return this.title;
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemStack)this.icon);
    }
}

