/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.registries;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.yanny.ali.registries.GameplayLootCategory;
import com.yanny.ali.registries.LootCategory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class LootCategories {
    public static final Map<ResourceLocation, LootCategory<Block>> BLOCK_LOOT_CATEGORIES = new HashMap<ResourceLocation, LootCategory<Block>>();
    public static final Map<ResourceLocation, LootCategory<Entity>> ENTITY_LOOT_CATEGORIES = new HashMap<ResourceLocation, LootCategory<Entity>>();
    public static final Map<ResourceLocation, LootCategory<String>> GAMEPLAY_LOOT_CATEGORIES = new HashMap<ResourceLocation, LootCategory<String>>();
    public static final LootCategory<Block> PLANT_LOOT = LootCategories.getBlockCategory("plant_loot", Items.DIAMOND_HOE, block -> block instanceof BushBlock);
    public static final LootCategory<Block> BLOCK_LOOT = LootCategories.getBlockCategory("block_loot", Items.DIAMOND_PICKAXE, block -> true);
    public static final LootCategory<Entity> ENTITY_LOOT = LootCategories.getEntityCategory("entity_loot", Items.SKELETON_SKULL, entity -> true);
    public static final LootCategory<String> GAMEPLAY_LOOT = LootCategories.getGameplayCategory(path -> true);
    private static final Logger LOGGER = LogUtils.getLogger();

    @NotNull
    private static LootCategory<Block> getBlockCategory(String key, Item icon, Predicate<Block> validator) {
        return new LootCategory<Block>(key, new ItemStack((ItemLike)icon), LootCategory.Type.BLOCK, validator);
    }

    @NotNull
    private static LootCategory<Entity> getEntityCategory(String key, Item icon, Predicate<Entity> validator) {
        return new LootCategory<Entity>(key, new ItemStack((ItemLike)icon), LootCategory.Type.ENTITY, validator);
    }

    @NotNull
    private static LootCategory<String> getGameplayCategory(Predicate<String> validator) {
        return new GameplayLootCategory("gameplay_loot", new ItemStack((ItemLike)Items.COMPASS), LootCategory.Type.GAMEPLAY, validator);
    }

    @NotNull
    private static LootCategory<String> getGameplayCategory(String key, Item icon, List<Pattern> prefix) {
        return new GameplayLootCategory(key, new ItemStack((ItemLike)icon), LootCategory.Type.GAMEPLAY, prefix);
    }

    @NotNull
    public static SimpleJsonResourceReloadListener<JsonElement> getReloadListener(Gson gson, String id) {
        return new SimpleJsonResourceReloadListener<JsonElement>(ExtraCodecs.JSON, FileToIdConverter.json((String)id)){

            protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
                BLOCK_LOOT_CATEGORIES.clear();
                ENTITY_LOOT_CATEGORIES.clear();
                GAMEPLAY_LOOT_CATEGORIES.clear();
                map.forEach((location, value) -> {
                    try {
                        JsonObject jsonObject = GsonHelper.convertToJsonObject((JsonElement)value, (String)location.toString());
                        LootCategory.Type type = LootCategory.Type.valueOf(GsonHelper.getAsString((JsonObject)jsonObject, (String)"type"));
                        String key = GsonHelper.getAsString((JsonObject)jsonObject, (String)"key");
                        Item icon = (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)jsonObject, (String)"icon")));
                        switch (type) {
                            case BLOCK: {
                                BLOCK_LOOT_CATEGORIES.put((ResourceLocation)location, LootCategories.getBlockCategory(key, icon, block -> true));
                                break;
                            }
                            case ENTITY: {
                                ENTITY_LOOT_CATEGORIES.put((ResourceLocation)location, LootCategories.getEntityCategory(key, icon, entity -> true));
                                break;
                            }
                            case GAMEPLAY: {
                                GAMEPLAY_LOOT_CATEGORIES.put((ResourceLocation)location, LootCategories.getGameplayCategory(key, icon, GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"prefix").asList().stream().map(JsonElement::getAsString).map(Pattern::compile).toList()));
                            }
                        }
                        LOGGER.info("Loaded LootCategory resource: {}", location);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to load LootCategory resource: {}", location, (Object)e);
                    }
                });
            }
        };
    }
}

