/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.EntityStorage;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.jei.JeiBaseLoot;
import com.yanny.ali.compatibility.jei.RecipeHolder;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.platform.Services;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class JeiEntityLoot
extends JeiBaseLoot<EntityLootType, class_1299<?>> {
    private static final int WIDGET_SIZE = 36;

    public JeiEntityLoot(IGuiHelper guiHelper, RecipeType<RecipeHolder<EntityLootType>> recipeType, LootCategory<class_1299<?>> lootCategory, class_2561 title, IDrawable icon) {
        super(guiHelper, recipeType, lootCategory, title, icon);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<EntityLootType> recipe, IFocusGroup iFocusGroup) {
        super.setRecipe(builder, recipe, iFocusGroup);
        class_1826 spawnEgg = Services.getPlatform().getSpawnEggItem(recipe.type().entityType());
        if (spawnEgg != null) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 1, 1).addItemStack(spawnEgg.method_7854());
        }
    }

    @NotNull
    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(this.getWidth(), this.getHeight());
    }

    @Override
    public void draw(RecipeHolder<EntityLootType> recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        class_327 font = class_310.method_1551().field_1772;
        this.guiHelper.getSlotDrawable().draw(guiGraphics, 0, 0);
        guiGraphics.method_51439(font, recipe.type().entityType().method_5897(), (162 - font.method_27525((class_5348)recipe.type().entityType().method_5897())) / 2, 0, 0, false);
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            class_1297 entity = EntityStorage.getEntity(PluginManager.COMMON_REGISTRY, recipe.type().entityType(), (class_1937)level, recipe.type().variant());
            GenericUtils.renderEntity(entity, new Rect(63, 10, 36, 36), 162, guiGraphics, (int)mouseX, (int)mouseY);
        }
    }

    @Override
    int getYOffset(EntityLootType recipe) {
        return 48;
    }

    @Override
    IWidget getRootWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        return new LootTableWidget(utils, entry, rect, maxWidth);
    }
}

