/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.manager.AliServerRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.DoneMessage;
import com.yanny.ali.network.LootDataChunkMessage;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.server.ItemCollectorUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9383;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

public abstract class AbstractServer {
    private static final int MAX_CHUNK_SIZE = 32768;
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("#0.00");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<LootDataChunkMessage> chunks = new ArrayList<LootDataChunkMessage>();

    public final void readLootTables(class_9383.class_9385 manager, class_3218 level) {
        LOGGER.info("Started reading loot info");
        long startTime = System.currentTimeMillis();
        AliConfig config = PluginManager.COMMON_REGISTRY.getConfiguration();
        AliServerRegistry serverRegistry = PluginManager.SERVER_REGISTRY;
        Map<class_2960, class_52> lootTables = AbstractServer.collectLootTables(manager);
        Map<class_2960, IDataNode> lootNodes = new HashMap<class_2960, IDataNode>();
        HashMap<class_2960, class_52> unprocessedLootTables = new HashMap<class_2960, class_52>(lootTables);
        List<ILootModifier<?>> lootModifiers = serverRegistry.getLootModifiers();
        Map<ILootModifier.IType, List<ILootModifier>> groupedTypes = lootModifiers.stream().collect(Collectors.groupingBy(ILootModifier::getType));
        List<ILootModifier<?>> blockLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.BLOCK, Collections.emptyList());
        List<ILootModifier<?>> entityLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.ENTITY, Collections.emptyList());
        List<ILootModifier<?>> lootTableLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.LOOT_TABLE, Collections.emptyList());
        HashMap<class_2960, Pair<List<class_1792>, List<class_1792>>> tradeItems = new HashMap<class_2960, Pair<List<class_1792>, List<class_1792>>>();
        Pair<List<class_1792>, List<class_1792>> wanderingTraderItems = ItemCollectorUtils.collectTradeItems(serverRegistry, (Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17724);
        IDataNode wanderingTraderNode = AbstractServer.processWanderingTrader(serverRegistry);
        serverRegistry.setServerLevel(level);
        lootTables.forEach(serverRegistry::addLootTable);
        Map<class_2960, List<class_1792>> lootTableItems = lootTables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, AbstractServer::getItems));
        this.chunks.clear();
        lootNodes.putAll(AbstractServer.processBlocks(serverRegistry, config, unprocessedLootTables, blockLootModifiers, lootTableLootModifiers, lootTableItems));
        lootNodes.putAll(AbstractServer.processEntities(serverRegistry, config, level, unprocessedLootTables, entityLootModifiers, lootTableLootModifiers, lootTableItems));
        lootNodes.putAll(AbstractServer.processLootTables(serverRegistry, config, unprocessedLootTables, lootTableLootModifiers, lootTableItems));
        Map<class_2960, List<class_1799>> lootTableItemStacks = lootNodes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> AbstractServer.collectItems((IDataNode)e.getValue())));
        lootNodes = AbstractServer.removeEmptyLootTable(serverRegistry, lootNodes, lootTableItemStacks);
        HashMap<class_2960, IDataNode> tradeNodes = new HashMap<class_2960, IDataNode>(AbstractServer.processTrades(serverRegistry, config, tradeItems));
        LOGGER.info("Processing {} loot tables and {} trades took {}ms", new Object[]{lootNodes.size(), tradeNodes.size() + 1, System.currentTimeMillis() - startTime});
        ByteBuf rawBuf = Unpooled.buffer();
        class_9129 buf = new class_9129(rawBuf, level.method_30349());
        this.writeLootData(buf, lootTableItemStacks, lootNodes);
        this.writeTradeData(buf, tradeNodes, tradeItems, wanderingTraderNode, wanderingTraderItems);
        this.compressAndStoreData(rawBuf);
        serverRegistry.clearLootTables();
        serverRegistry.printRuntimeInfo();
    }

    public final void syncLootTables(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            LOGGER.info("Started syncing loot info to {}", (Object)player.method_5820());
            this.sendClearMessage(serverPlayer, new ClearMessage(this.chunks.size()));
            for (LootDataChunkMessage message : this.chunks) {
                try {
                    this.sendSyncLootTableMessage(serverPlayer, message);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to send message with error: {}", (Object)e.getMessage());
                }
            }
            this.sendDoneMessage(serverPlayer, new DoneMessage());
            LOGGER.info("Finished syncing loot info to {}", (Object)player.method_5820());
        }
    }

    protected abstract void sendClearMessage(class_3222 var1, ClearMessage var2);

    protected abstract void sendSyncLootTableMessage(class_3222 var1, LootDataChunkMessage var2);

    protected abstract void sendDoneMessage(class_3222 var1, DoneMessage var2);

    @NotNull
    private static List<class_1792> getItems(Map.Entry<class_2960, class_52> lootTableMap) {
        return ItemCollectorUtils.collectLootTable(PluginManager.SERVER_REGISTRY, lootTableMap.getValue());
    }

    @NotNull
    private static Map<class_2960, IDataNode> removeEmptyLootTable(AliServerRegistry serverRegistry, Map<class_2960, IDataNode> lootNodes, Map<class_2960, List<class_1799>> items) {
        HashMap<class_2960, IDataNode> result = new HashMap<class_2960, IDataNode>();
        int emptyLootTables = 0;
        int injectedLootTables = 0;
        for (Map.Entry<class_2960, IDataNode> entry : lootNodes.entrySet()) {
            if (!items.getOrDefault(entry.getKey(), Collections.emptyList()).isEmpty()) {
                if (!serverRegistry.isSubTable(entry.getKey())) {
                    result.put(entry.getKey(), entry.getValue());
                    continue;
                }
                ++injectedLootTables;
                continue;
            }
            ++emptyLootTables;
        }
        LOGGER.info("Skipped {} empty or hidden loot tables and {} injected loot tables", (Object)emptyLootTables, (Object)injectedLootTables);
        return result;
    }

    @NotNull
    private static Map<class_2960, class_52> collectLootTables(class_9383.class_9385 manager) {
        HashMap<class_2960, class_52> lootTables = new HashMap<class_2960, class_52>();
        manager.method_58289().method_46759(class_7924.field_50079).ifPresent(lookup -> lookup.method_42017().forEach(reference -> lootTables.put(reference.method_40237().method_29177(), (class_52)reference.comp_349())));
        return lootTables;
    }

    @NotNull
    private static Map<class_2960, IDataNode> processBlocks(AliServerRegistry serverRegistry, AliConfig config, Map<class_2960, class_52> lootTables, List<ILootModifier<?>> blockLootModifiers, List<ILootModifier<?>> lootTableLootModifiers, Map<class_2960, List<class_1792>> lootTableItems) {
        HashMap<class_2960, IDataNode> lootNodes = new HashMap<class_2960, IDataNode>();
        for (class_2248 block : class_7923.field_41175) {
            class_5321 resourceKey = block.method_26162();
            if (resourceKey == null) continue;
            class_2960 location = resourceKey.method_29177();
            class_52 lootTable = lootTables.remove(location);
            if (config.blockCategories.stream().filter(f -> f.validate(block)).findFirst().map(f -> !f.isHidden()).orElse(false).booleanValue()) {
                List items = lootTableItems.getOrDefault(location, Collections.emptyList());
                List<ILootModifier<?>> lootModifiers = Stream.concat(blockLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, block, items)), lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items))).toList();
                try {
                    if (lootTable != null) {
                        lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
                        continue;
                    }
                    if (!lootModifiers.isEmpty()) {
                        lootNodes.put(location, serverRegistry.parseTable(lootModifiers));
                        continue;
                    }
                    LOGGER.debug("Missing block loot table for {}", (Object)block);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to parse block loot table {} with error {}", (Object)location, (Object)e.getMessage());
                }
                continue;
            }
            lootTables.remove(location);
        }
        return lootNodes;
    }

    @NotNull
    private static Map<class_2960, IDataNode> processEntities(AliServerRegistry serverRegistry, AliConfig config, class_3218 level, Map<class_2960, class_52> lootTables, List<ILootModifier<?>> entityLootModifiers, List<ILootModifier<?>> lootTableLootModifiers, Map<class_2960, List<class_1792>> lootTableItems) {
        HashMap<class_2960, IDataNode> lootNodes = new HashMap<class_2960, IDataNode>();
        for (class_1299 entityType : class_7923.field_41177) {
            if (config.disabledEntities.stream().anyMatch(f -> f.equals((Object)class_7923.field_41177.method_10221((Object)entityType)))) {
                lootTables.remove(entityType.method_16351().method_29177());
                continue;
            }
            List<class_1297> entityList = serverRegistry.createEntities(entityType, (class_1937)level);
            for (class_1297 entity : entityList) {
                class_1308 mob;
                class_5321 resourceKey;
                if (!(entity instanceof class_1308) || (resourceKey = (mob = (class_1308)entity).method_5989()) == null) continue;
                class_2960 location = resourceKey.method_29177();
                class_52 lootTable = lootTables.remove(location);
                if (!config.entityCategories.stream().filter(f -> f.validate(entityType)).findFirst().map(f -> !f.isHidden()).orElse(false).booleanValue()) continue;
                List items = lootTableItems.getOrDefault(location, Collections.emptyList());
                List<ILootModifier<?>> lootModifiers = Stream.concat(entityLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, entity, items)), lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items))).toList();
                try {
                    if (lootTable != null) {
                        lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
                        continue;
                    }
                    if (!lootModifiers.isEmpty()) {
                        lootNodes.put(location, serverRegistry.parseTable(lootModifiers));
                        continue;
                    }
                    LOGGER.debug("Missing entity loot table for {}", (Object)entity);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to parse entity loot table {} with error {}", (Object)location, (Object)e.getMessage());
                }
            }
        }
        return lootNodes;
    }

    @NotNull
    private static Map<class_2960, IDataNode> processLootTables(AliServerRegistry serverRegistry, AliConfig config, Map<class_2960, class_52> lootTables, List<ILootModifier<?>> lootTableLootModifiers, Map<class_2960, List<class_1792>> lootTableItems) {
        HashMap<class_2960, IDataNode> lootNodes = new HashMap<class_2960, IDataNode>();
        for (Map.Entry<class_2960, class_52> entry : lootTables.entrySet()) {
            class_2960 location = entry.getKey();
            if (!config.gameplayCategories.stream().filter(f -> f.validate(location)).findFirst().map(f -> !f.isHidden()).orElse(false).booleanValue()) continue;
            class_52 lootTable = entry.getValue();
            List<class_1792> items = lootTableItems.get(location);
            List<ILootModifier<?>> lootModifiers = lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items)).toList();
            try {
                lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOGGER.warn("Failed to parse loot table {} with error {}", (Object)location, (Object)e.getMessage());
            }
        }
        lootTables.clear();
        return lootNodes;
    }

    @NotNull
    private static Map<class_2960, IDataNode> processTrades(AliServerRegistry serverRegistry, AliConfig config, Map<class_2960, Pair<List<class_1792>, List<class_1792>>> tradeItems) {
        HashMap<class_2960, IDataNode> nodes = new HashMap<class_2960, IDataNode>();
        for (Map.Entry entry : class_7923.field_41195.method_29722()) {
            class_2960 location = ((class_5321)entry.getKey()).method_29177();
            if (!config.tradeCategories.stream().filter(f -> f.validate(location)).findFirst().map(f -> !f.isHidden()).orElse(false).booleanValue()) continue;
            Int2ObjectMap itemListingMap = (Int2ObjectMap)class_3853.field_17067.get(entry.getValue());
            if (itemListingMap != null && itemListingMap.int2ObjectEntrySet().stream().anyMatch(e -> ((class_3853.class_1652[])e.getValue()).length > 0)) {
                try {
                    nodes.put(location, serverRegistry.parseTrade((Int2ObjectMap<class_3853.class_1652[]>)itemListingMap));
                    tradeItems.put(location, ItemCollectorUtils.collectTradeItems(serverRegistry, (Int2ObjectMap<class_3853.class_1652[]>)itemListingMap));
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                    LOGGER.warn("Failed to parse trade for villager {} with error {}", (Object)((class_3852)entry.getValue()).comp_818(), (Object)e2.getMessage());
                }
                continue;
            }
            LOGGER.warn("No trades defined for {}", (Object)location);
        }
        return nodes;
    }

    @NotNull
    private static IDataNode processWanderingTrader(AliServerRegistry serverRegistry) {
        try {
            return serverRegistry.parseTrade((Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17724);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Failed to parse wandering trader with error {}", (Object)e.getMessage());
            return new MissingNode(EmptyTooltipNode.EMPTY);
        }
    }

    private static <T> boolean predicateModifier(ILootModifier<?> modifier, T value, List<class_1792> items) {
        return modifier.predicate(value) && AbstractServer.predicateItem(modifier, items);
    }

    private static boolean predicateItem(ILootModifier<?> modifier, List<class_1792> items) {
        if (!items.isEmpty()) {
            return items.stream().anyMatch(i -> modifier.getOperations().stream().anyMatch(o -> o.predicate().test(i.method_7854())));
        }
        return true;
    }

    @NotNull
    private static List<class_1799> collectItems(IDataNode node) {
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            for (IDataNode n : listNode.nodes()) {
                itemStacks.addAll(AbstractServer.collectItems(n));
            }
        } else if (node instanceof IItemNode) {
            IItemNode itemNode = (IItemNode)((Object)node);
            itemStacks.addAll((Collection)itemNode.getModifiedItem().map(List::of, AbstractServer::toItemStacks));
        }
        return itemStacks;
    }

    private void writeLootData(class_9129 buf, Map<class_2960, List<class_1799>> lootTableItemStacks, Map<class_2960, IDataNode> lootNodes) {
        AliServerRegistry utils = PluginManager.SERVER_REGISTRY;
        buf.method_34062(lootNodes.entrySet(), (f, e) -> {
            f.method_10812((class_2960)e.getKey());
            ((IDataNode)e.getValue()).encode(utils, (class_9129)f);
            class_1799.field_49269.encode((Object)((class_9129)f), lootTableItemStacks.getOrDefault(e.getKey(), Collections.emptyList()));
        });
        lootNodes.clear();
        lootTableItemStacks.clear();
    }

    private void writeTradeData(class_9129 buf, Map<class_2960, IDataNode> trades, Map<class_2960, Pair<List<class_1792>, List<class_1792>>> items, IDataNode wanderingTraderNode, Pair<List<class_1792>, List<class_1792>> wanderingTraderItems) {
        AliServerRegistry utils = PluginManager.SERVER_REGISTRY;
        buf.method_34062(trades.entrySet(), (f, e) -> {
            Pair pair = items.getOrDefault(e.getKey(), new Pair(Collections.emptyList(), Collections.emptyList()));
            f.method_10812((class_2960)e.getKey());
            ((IDataNode)e.getValue()).encode(utils, (class_9129)f);
            f.method_34062((Collection)pair.getA(), (b, i) -> b.method_10812(class_7923.field_41178.method_10221(i)));
            f.method_34062((Collection)pair.getB(), (b, i) -> b.method_10812(class_7923.field_41178.method_10221(i)));
        });
        wanderingTraderNode.encode(utils, buf);
        buf.method_34062((Collection)wanderingTraderItems.getA(), (b, i) -> b.method_10812(class_7923.field_41178.method_10221(i)));
        buf.method_34062((Collection)wanderingTraderItems.getB(), (b, i) -> b.method_10812(class_7923.field_41178.method_10221(i)));
        trades.clear();
        items.clear();
    }

    private void compressAndStoreData(ByteBuf rawBuf) {
        int rawSize = rawBuf.readableBytes();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(rawSize);
        try (GZIPOutputStream gzip = new GZIPOutputStream(bos);){
            rawBuf.readBytes((OutputStream)gzip, rawBuf.readableBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        byte[] compressedData = bos.toByteArray();
        int totalChunks = (int)Math.ceil((double)compressedData.length / 32768.0);
        for (int i = 0; i < totalChunks; ++i) {
            int offset = i * 32768;
            int length = Math.min(32768, compressedData.length - offset);
            byte[] chunkData = new byte[length];
            System.arraycopy(compressedData, offset, chunkData, 0, length);
            this.chunks.add(new LootDataChunkMessage(i, chunkData));
        }
        rawBuf.release();
        LOGGER.info("Compressed loot data ({} MB -> {} MB) and stored in {} chunk(s)", new Object[]{DOUBLE_FORMAT.format((double)rawSize / 1024.0 / 1024.0), DOUBLE_FORMAT.format((double)compressedData.length / 1024.0 / 1024.0), totalChunks});
    }

    private static <T extends class_1935> List<class_1799> toItemStacks(class_6862<T> tag) {
        class_2378 registry = (class_2378)class_7923.field_41167.method_10223(tag.comp_326().method_29177());
        if (registry != null) {
            return registry.method_40266(tag).map(holders -> holders.method_40239().map(class_6880::comp_349).map(i -> i.method_8389().method_7854()).toList()).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }
}

