/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_117;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_6880;
import net.minecraft.class_83;
import net.minecraft.class_9129;

public class ReferenceNode
extends ListNode {
    public static final class_2960 ID = new class_2960("ali", "reference");
    private final ITooltipNode tooltip;
    private final float chance;

    public ReferenceNode(IServerUtils utils, class_83 entry, float chance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        List<class_117> allFunctions = Stream.concat(functions.stream(), entry.field_996.stream()).toList();
        List<class_5341> allConditions = Stream.concat(conditions.stream(), entry.field_988.stream()).toList();
        class_52 lootTable = utils.getLootTable((Either<class_2960, class_52>)entry.field_49429.mapLeft(class_5321::method_29177));
        if (lootTable != null) {
            this.addChildren(new LootTableNode(utils, lootTable, chance * (float)entry.field_995 / (float)sumWeight, allFunctions, allConditions));
        } else {
            this.addChildren(new MissingNode(utils.getValueTooltip(utils, entry.field_49429.mapLeft(class_5321::method_29177)).build("ali.property.value.loot_table")));
        }
        this.chance = chance * (float)entry.field_995 / (float)sumWeight;
        this.tooltip = EntryTooltipUtils.getReferenceTooltip(entry, chance, sumWeight);
    }

    public ReferenceNode(IServerUtils utils, class_2960 table, List<class_5341> conditions, ITooltipNode tooltip) {
        Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance = TooltipUtils.getChance(utils, conditions, 1.0f);
        class_52 lootTable = utils.getLootTable((Either<class_2960, class_52>)Either.left((Object)table));
        if (lootTable != null) {
            this.addChildren(new LootTableNode(utils, lootTable, 1.0f, Collections.emptyList(), conditions));
        } else {
            this.addChildren(new MissingNode(utils.getValueTooltip(utils, table).build("ali.property.value.loot_table")));
        }
        this.chance = chance.get(null).get(0).min();
        this.tooltip = tooltip;
    }

    public ReferenceNode(IClientUtils utils, class_9129 buf) {
        super(utils, buf);
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
        this.chance = buf.readFloat();
    }

    @Override
    public void encodeNode(IServerUtils utils, class_9129 buf) {
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
        buf.method_52941(this.chance);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public float getChance() {
        return this.chance;
    }
}

