/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.api;

import com.yanny.ali.api.ITooltipNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public final class TooltipNode
implements ITooltipNode {
    private final List<ITooltipNode> children;
    private final Component component;
    private final boolean advancedTooltip;

    public TooltipNode() {
        this((Component)Component.empty(), false);
    }

    public TooltipNode(Component component) {
        this(component, false);
    }

    public TooltipNode(Component component, boolean advancedTooltip) {
        this.children = new ArrayList<ITooltipNode>();
        this.component = component;
        this.advancedTooltip = advancedTooltip;
    }

    public TooltipNode(FriendlyByteBuf buf) {
        int count = buf.readInt();
        this.children = new ArrayList<ITooltipNode>(count);
        this.advancedTooltip = buf.readBoolean();
        this.component = buf.readComponent();
        for (int i = 0; i < count; ++i) {
            this.children.add(new TooltipNode(buf));
        }
    }

    @Override
    public void add(ITooltipNode node) {
        this.children.add(node);
    }

    @Override
    public List<ITooltipNode> getChildren() {
        return this.children;
    }

    @Override
    public Component getContent() {
        return this.component;
    }

    @Override
    public boolean isAdvancedTooltip() {
        return this.advancedTooltip;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.children.size());
        buf.writeBoolean(this.advancedTooltip);
        buf.writeComponent(this.component);
        for (ITooltipNode child : this.children) {
            child.encode(buf);
        }
    }
}

