/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods.sawmill;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.trades.ItemsToItemsNode;
import com.yanny.ali.plugin.common.trades.SubTradesNode;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.FieldAccessor;
import com.yanny.ali.plugin.mods.IItemListing;
import com.yanny.ali.plugin.mods.sawmill.Utils;
import com.yanny.ali.plugin.mods.sawmill.WoodType;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import oshi.util.tuples.Pair;

@ClassAccessor(value="net.mehvahdjukaar.sawmill.CarpenterTrades$LogStrippingListing")
public class LogStrippingListing
extends BaseAccessor<VillagerTrades.ItemListing>
implements IItemListing {
    @FieldAccessor
    private ItemStack price;
    @FieldAccessor
    private int amount;
    @FieldAccessor
    private int maxTrades;
    @FieldAccessor
    private int xp;
    @FieldAccessor
    private float priceMult;

    public LogStrippingListing(VillagerTrades.ItemListing parent) {
        super(parent);
    }

    @Override
    public IDataNode getNode(IServerUtils utils, List<ITooltipNode> conditions) {
        return new SubTradesNode<LogStrippingListing>(utils, this, conditions){

            @Override
            public List<IDataNode> getSubTrades(IServerUtils utils, LogStrippingListing listing) {
                ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
                for (VillagerType type : BuiltInRegistries.VILLAGER_TYPE) {
                    List<WoodType> woodTypes = Utils.WOOD_TYPES.get(type);
                    if (woodTypes == null) continue;
                    for (WoodType woodType : woodTypes) {
                        Item log = woodType.log.asItem();
                        Item stripped = woodType.getItemOfThis("stripped_log");
                        if (stripped == null) continue;
                        nodes.add(new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)log.getDefaultInstance()), new RangeValue(LogStrippingListing.this.amount), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)LogStrippingListing.this.price), new RangeValue(LogStrippingListing.this.price.getCount()), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)stripped.getDefaultInstance()), new RangeValue(LogStrippingListing.this.amount), LogStrippingListing.this.maxTrades, LogStrippingListing.this.xp, LogStrippingListing.this.priceMult, List.of(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.villager_type", type.toString()))));
                    }
                }
                return nodes;
            }
        };
    }

    @Override
    public Pair<List<Item>, List<Item>> collectItems(IServerUtils utils) {
        ArrayList inputs = new ArrayList(BuiltInRegistries.VILLAGER_TYPE.stream().map(Utils.WOOD_TYPES::get).filter(Objects::nonNull).flatMap(e -> e.stream().flatMap(w -> {
            Item stripped = w.getItemOfThis("stripped_log");
            return stripped != null ? Stream.of(w.log.asItem()) : Stream.of(new Item[0]);
        })).toList());
        List outputs = BuiltInRegistries.VILLAGER_TYPE.stream().map(Utils.WOOD_TYPES::get).filter(Objects::nonNull).flatMap(e -> e.stream().flatMap(w -> {
            Item stripped = w.getItemOfThis("stripped_log");
            return stripped != null ? Stream.of(stripped) : Stream.of(new Item[0]);
        })).toList();
        inputs.add(this.price.getItem());
        return new Pair(inputs, outputs);
    }
}

