/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.Rect;
import java.util.Optional;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JeiLootSlotWidget
implements ISlottedRecipeWidget {
    private final Rect rect;
    private final IRecipeSlotDrawable slotDrawable;
    @Nullable
    private Component count;
    private boolean isRange = false;

    public JeiLootSlotWidget(IRecipeSlotDrawable slotDrawable, int x, int y, RangeValue count) {
        this.slotDrawable = slotDrawable;
        this.rect = new Rect(x, y, 18, 18);
        this.setCount(count);
    }

    @NotNull
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
        if (this.slotDrawable.isMouseOver(mouseX, mouseY)) {
            return Optional.of(new RecipeSlotUnderMouse(this.slotDrawable, 0, 0));
        }
        return Optional.empty();
    }

    @NotNull
    public ScreenPosition getPosition() {
        return new ScreenPosition(this.rect.x(), this.rect.y());
    }

    public void drawWidget(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        PoseStack stack = guiGraphics.m_280168_();
        stack.m_252880_(1.0f, 1.0f, 0.0f);
        this.slotDrawable.draw(guiGraphics);
        stack.m_252880_(-1.0f, -1.0f, 0.0f);
        if (this.count != null) {
            Font font = Minecraft.m_91087_().f_91062_;
            stack.m_85836_();
            stack.m_252880_((float)this.rect.x(), (float)this.rect.y(), 0.0f);
            if (this.isRange) {
                stack.m_252880_(17.0f, 13.0f, 200.0f);
                stack.m_85836_();
                stack.m_85841_(0.5f, 0.5f, 0.5f);
                guiGraphics.m_280614_(font, this.count, -font.m_92852_((FormattedText)this.count), 0, 0xFFFFFF, false);
                stack.m_85849_();
            } else {
                stack.m_252880_(18.0f, 10.0f, 200.0f);
                guiGraphics.m_280614_(font, this.count, -font.m_92852_((FormattedText)this.count), 0, 0xFFFFFF, true);
            }
            stack.m_85849_();
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, double mouseX, double mouseY) {
        if (this.slotDrawable.isMouseOver(mouseX, mouseY)) {
            this.slotDrawable.getTooltip(tooltip);
        }
    }

    private void setCount(RangeValue count) {
        if (count.isRange() || count.min() > 1.0f) {
            this.count = Component.m_237113_((String)count.toIntString());
            this.isRange = count.isRange();
        }
    }
}

