/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.emi;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.IMouseEvents;
import com.yanny.ali.plugin.client.WidgetUtils;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class EmiScrollWidget
extends Widget
implements IMouseEvents {
    private static final int SCROLLBAR_PADDING = 2;
    private static final int SCROLLBAR_WIDTH = 8;
    private static final int MIN_SCROLL_MARKER_HEIGHT = 14;
    private static final int SCROLL_RATE = 8;
    private final Rect rect;
    private final Rect contentRect;
    private final Rect scrollRect;
    private final List<Widget> widgets;
    private double dragOriginY = -1.0;
    private float scrollOffsetY = 0.0f;

    public EmiScrollWidget(Rect rect, int contentHeight, List<Widget> widgets) {
        this.rect = rect;
        this.widgets = widgets;
        this.contentRect = new Rect(0, 0, rect.width() - EmiScrollWidget.getScrollBoxScrollbarExtraWidth(), contentHeight);
        this.scrollRect = EmiScrollWidget.calculateScrollArea(rect.width(), rect.height());
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double scrollDeltaY) {
        if (this.rect.contains((int)mouseX, (int)mouseY)) {
            if (this.getHiddenAmount() > 0) {
                this.scrollOffsetY -= this.calculateScrollAmount(scrollDeltaY);
                this.scrollOffsetY = Mth.m_14036_((float)this.scrollOffsetY, (float)0.0f, (float)1.0f);
            } else {
                this.scrollOffsetY = 0.0f;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.rect.contains((int)mouseX, (int)mouseY)) {
            if (this.dragOriginY < 0.0 || button != 0) {
                return false;
            }
            Rect scrollbarMarkerArea = this.calculateScrollbarMarkerArea();
            double topY = mouseY - this.dragOriginY;
            this.moveScrollbarTo(scrollbarMarkerArea, topY);
            return true;
        }
        return false;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.scrollRect.contains(mouseX, mouseY)) {
            if (this.getHiddenAmount() == 0) {
                return false;
            }
            if (button == 0) {
                Rect scrollMarkerArea = this.calculateScrollbarMarkerArea();
                if (!scrollMarkerArea.contains(mouseX, mouseY)) {
                    this.moveScrollbarCenterTo(scrollMarkerArea, mouseY);
                    scrollMarkerArea = this.calculateScrollbarMarkerArea();
                }
                this.dragOriginY = mouseY - scrollMarkerArea.y();
            }
            return true;
        }
        if (this.contentRect.contains(mouseX, mouseY)) {
            float scrollAmount = (float)this.getHiddenAmount() * this.scrollOffsetY;
            for (Widget widget : this.widgets) {
                Bounds b = widget.getBounds();
                if (!b.contains(mouseX, (int)((float)mouseY + scrollAmount)) || !widget.mouseClicked(mouseX, (int)((float)mouseY + scrollAmount), button)) continue;
                return true;
            }
        }
        return false;
    }

    public Bounds getBounds() {
        return new Bounds(this.rect.x(), this.rect.y(), this.rect.width(), this.rect.height());
    }

    public void m_88315_(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        WidgetUtils.blitNineSliced(draw, WidgetUtils.TEXTURE_LOC, this.scrollRect.x(), this.scrollRect.y(), this.scrollRect.width(), this.scrollRect.height(), 2, 2, 2, 2, 16, 16, 2, 2);
        Rect markerArea = this.calculateScrollbarMarkerArea();
        WidgetUtils.blitNineSliced(draw, WidgetUtils.TEXTURE_LOC, markerArea.x(), markerArea.y(), markerArea.width(), markerArea.height(), 2, 2, 2, 1, 12, 17, 18, 0);
        this.drawContents(draw, mouseX, mouseY, this.scrollOffsetY);
    }

    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        LinkedList<ClientTooltipComponent> components = new LinkedList<ClientTooltipComponent>();
        float scrollAmount = (float)this.getHiddenAmount() * this.scrollOffsetY;
        for (Widget widget : this.widgets) {
            Bounds b = widget.getBounds();
            if (!b.contains(mouseX, (int)((float)mouseY + scrollAmount))) continue;
            components.addAll(widget.getTooltip(mouseX, (int)((float)mouseY + scrollAmount)));
        }
        return components;
    }

    protected Rect calculateScrollbarMarkerArea() {
        int totalSpace = this.scrollRect.height() - 2;
        int scrollMarkerWidth = this.scrollRect.width() - 2;
        int scrollMarkerHeight = Math.round((float)totalSpace * Math.min(1.0f, (float)this.rect.height() / (float)this.contentRect.height()));
        scrollMarkerHeight = Math.max(scrollMarkerHeight, 14);
        int scrollbarMarkerY = Math.round((float)(totalSpace - scrollMarkerHeight) * this.scrollOffsetY);
        return new Rect(this.scrollRect.x() + 1, this.scrollRect.y() + 1 + scrollbarMarkerY, scrollMarkerWidth, scrollMarkerHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawContents(GuiGraphics guiGraphics, double mouseX, double mouseY, float scrollOffsetY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        PoseStack.Pose last = poseStack.m_85850_();
        Matrix4f pose = last.m_252922_();
        ScreenRectangle scissorArea = EmiScrollWidget.transform(this.rect, pose);
        float scrollAmount = (float)this.getHiddenAmount() * scrollOffsetY;
        guiGraphics.m_280588_(scissorArea.m_274563_(), scissorArea.m_274449_(), scissorArea.m_274445_(), scissorArea.m_274349_());
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)(-scrollAmount), 0.0);
        try {
            this.widgets.forEach(widget -> widget.m_88315_(guiGraphics, (int)mouseX, (int)(mouseY + (double)scrollAmount), 0.0f));
        }
        finally {
            poseStack.m_85849_();
            guiGraphics.m_280618_();
        }
    }

    private void moveScrollbarCenterTo(Rect scrollMarkerArea, double centerY) {
        double topY = centerY - (double)scrollMarkerArea.height() / 2.0;
        this.moveScrollbarTo(scrollMarkerArea, topY);
    }

    private void moveScrollbarTo(Rect scrollMarkerArea, double topY) {
        int minY = this.scrollRect.y();
        int maxY = this.scrollRect.y() + this.scrollRect.height() - scrollMarkerArea.height();
        double relativeY = topY - (double)minY;
        int totalSpace = maxY - minY;
        this.scrollOffsetY = (float)(relativeY / (double)totalSpace);
        this.scrollOffsetY = Mth.m_14036_((float)this.scrollOffsetY, (float)0.0f, (float)1.0f);
    }

    private float calculateScrollAmount(double scrollDeltaY) {
        int totalHeight = Math.max(1, this.contentRect.height() - this.rect.height());
        double scrollAmount = scrollDeltaY * 8.0;
        return (float)(scrollAmount / (double)totalHeight);
    }

    private int getHiddenAmount() {
        return Math.max(this.contentRect.height() - this.rect.height(), 0);
    }

    @NotNull
    public static ScreenRectangle transform(Rect rect, Matrix4f pose) {
        Vector3f topLeft = new Vector3f((float)rect.x(), (float)rect.y(), 1.0f);
        Vector3f bottomRight = new Vector3f((float)(rect.x() + rect.width()), (float)(rect.y() + rect.height()), 1.0f);
        topLeft = pose.transformPosition(topLeft);
        bottomRight = pose.transformPosition(bottomRight);
        int x = Math.round(topLeft.x);
        int y = Math.round(topLeft.y);
        return new ScreenRectangle(x, y, Math.round(bottomRight.x) - x, Math.round(bottomRight.y) - y);
    }

    @NotNull
    private static Rect calculateScrollArea(int width, int height) {
        return new Rect(width - 8, 0, 8, height);
    }

    public static int getScrollBoxScrollbarExtraWidth() {
        return 10;
    }
}

