/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.jei.JeiBaseLoot;
import com.yanny.ali.compatibility.jei.RecipeHolder;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class JeiGameplayLoot
extends JeiBaseLoot<GameplayLootType, ResourceLocation> {
    public JeiGameplayLoot(IGuiHelper guiHelper, RecipeType<RecipeHolder<GameplayLootType>> recipeType, LootCategory<ResourceLocation> lootCategory, Component title, IDrawable icon) {
        super(guiHelper, recipeType, lootCategory, title, icon);
    }

    @NotNull
    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(this.getWidth(), this.getHeight());
    }

    @Override
    public void draw(RecipeHolder<GameplayLootType> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        String key = "ali/loot_table/" + recipe.type().id().substring(1);
        Component text = GenericUtils.ellipsis(key, recipe.type().id(), 162);
        MutableComponent fullText = Component.m_264568_((String)key, (String)recipe.type().id());
        Rect rect = new Rect(0, 0, 162, 8);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, text, 0, 0, 0, false);
        if (rect.contains((int)mouseX, (int)mouseY)) {
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)fullText, (int)mouseX, (int)mouseY);
        }
    }

    @Override
    int getYOffset(GameplayLootType recipe) {
        return 10;
    }

    @Override
    IWidget getRootWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        return new LootTableWidget(utils, entry, rect, maxWidth);
    }
}

