/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.yanny.ali.network.AbstractClient;
import com.yanny.ali.network.AbstractServer;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.Client;
import com.yanny.ali.network.DistHolder;
import com.yanny.ali.network.DoneMessage;
import com.yanny.ali.network.Server;
import com.yanny.ali.network.SyncLootTableMessage;
import com.yanny.ali.network.SyncTradeMessage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.SimpleChannel;
import org.jetbrains.annotations.NotNull;

public class NetworkUtils {
    private static int messageId = 0;

    public static DistHolder<AbstractClient, AbstractServer> registerLootInfoPropagator(SimpleChannel channel) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return NetworkUtils.registerClientLootInfoPropagator(channel);
        }
        return NetworkUtils.registerServerLootInfoPropagator(channel);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerClientLootInfoPropagator(SimpleChannel channel) {
        Client client = new Client();
        Server server = new Server(channel);
        channel.messageBuilder(SyncLootTableMessage.class, NetworkUtils.getMessageId()).encoder(SyncLootTableMessage::encode).decoder(SyncLootTableMessage::new).consumerNetworkThread(client::onLootInfo).add();
        channel.messageBuilder(SyncTradeMessage.class, NetworkUtils.getMessageId()).encoder(SyncTradeMessage::encode).decoder(SyncTradeMessage::new).consumerNetworkThread(client::onTradeInfo).add();
        channel.messageBuilder(ClearMessage.class, NetworkUtils.getMessageId()).encoder(ClearMessage::encode).decoder(ClearMessage::new).consumerNetworkThread(client::onClear).add();
        channel.messageBuilder(DoneMessage.class, NetworkUtils.getMessageId()).encoder(DoneMessage::encode).decoder(DoneMessage::new).consumerNetworkThread(client::onDone).add();
        return new DistHolder<AbstractClient, AbstractServer>(client, server);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerServerLootInfoPropagator(SimpleChannel channel) {
        Server server = new Server(channel);
        channel.messageBuilder(SyncLootTableMessage.class, NetworkUtils.getMessageId()).encoder(SyncLootTableMessage::encode).decoder(SyncLootTableMessage::new).add();
        channel.messageBuilder(SyncTradeMessage.class, NetworkUtils.getMessageId()).encoder(SyncTradeMessage::encode).decoder(SyncTradeMessage::new).add();
        channel.messageBuilder(ClearMessage.class, NetworkUtils.getMessageId()).encoder(ClearMessage::encode).decoder(ClearMessage::new).add();
        channel.messageBuilder(DoneMessage.class, NetworkUtils.getMessageId()).encoder(DoneMessage::encode).decoder(DoneMessage::new).add();
        return new DistHolder<Object, Server>(null, server);
    }

    private static int getMessageId() {
        return ++messageId;
    }
}

