/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class EntryTooltipUtils {
    public static @Unmodifiable @NotNull List<ITooltipNode> getLootTableTooltip() {
        return List.of(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.all", new Object[0])));
    }

    @NotNull
    public static List<ITooltipNode> getReferenceTooltip(LootTableReference entry, float chance, int sumWeight) {
        ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
        tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.all", new Object[0])));
        tooltip.add(EntryTooltipUtils.getQualityTooltip(entry.f_79676_));
        tooltip.add(EntryTooltipUtils.getChanceTooltip(EntryTooltipUtils.getBaseMap(chance * (float)entry.f_79675_ / (float)sumWeight * 100.0f)));
        return tooltip;
    }

    @NotNull
    public static List<ITooltipNode> getLootPoolTooltip(RangeValue rolls, RangeValue bonusRolls) {
        ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
        tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.random", new Object[0])));
        tooltip.add(EntryTooltipUtils.getRolls(rolls, bonusRolls));
        return tooltip;
    }

    public static @Unmodifiable @NotNull List<ITooltipNode> getAlternativesTooltip() {
        return List.of(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.alternatives", new Object[0])));
    }

    @NotNull
    public static List<ITooltipNode> getDynamicTooltip(IServerUtils utils, DynamicLoot entry, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
        tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.dynamic", new Object[0])));
        tooltip.add(EntryTooltipUtils.getQualityTooltip(entry.f_79676_));
        tooltip.add(EntryTooltipUtils.getChanceTooltip(EntryTooltipUtils.getBaseMap(chance * (float)entry.f_79675_ / (float)sumWeight * 100.0f)));
        tooltip.addAll(GenericTooltipUtils.getConditionsTooltip(utils, conditions));
        tooltip.addAll(GenericTooltipUtils.getFunctionsTooltip(utils, functions));
        return tooltip;
    }

    public static @Unmodifiable @NotNull List<ITooltipNode> getGroupTooltip() {
        return List.of(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.all", new Object[0])));
    }

    public static @Unmodifiable @NotNull List<ITooltipNode> getSequentialTooltip() {
        return List.of(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.sequence", new Object[0])));
    }

    @NotNull
    public static List<ITooltipNode> getEmptyTooltip(IServerUtils utils, LootPoolSingletonContainer entry, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
        ArrayList<LootItemFunction> allFunctions = new ArrayList<LootItemFunction>(functions);
        ArrayList<LootItemCondition> allConditions = new ArrayList<LootItemCondition>(conditions);
        allFunctions.addAll(entry.f_79677_);
        allConditions.addAll(entry.f_79636_);
        float rawChance = chance * (float)entry.f_79675_ / (float)sumWeight;
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap = TooltipUtils.getChance(utils, allConditions, rawChance);
        tooltip.add(new TooltipNode((Component)Component.m_237115_((String)"ali.enum.group_type.empty")));
        tooltip.add(EntryTooltipUtils.getQualityTooltip(entry.f_79676_));
        tooltip.add(EntryTooltipUtils.getChanceTooltip(chanceMap));
        tooltip.addAll(GenericTooltipUtils.getConditionsTooltip(utils, allConditions));
        tooltip.addAll(GenericTooltipUtils.getFunctionsTooltip(utils, allFunctions));
        return tooltip;
    }

    @NotNull
    public static List<ITooltipNode> getSingletonTooltip(IServerUtils utils, LootPoolSingletonContainer entry, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        ArrayList<LootItemFunction> allFunctions = new ArrayList<LootItemFunction>(functions);
        ArrayList<LootItemCondition> allConditions = new ArrayList<LootItemCondition>(conditions);
        allFunctions.addAll(entry.f_79677_);
        allConditions.addAll(entry.f_79636_);
        float rawChance = chance * (float)entry.f_79675_ / (float)sumWeight;
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap = TooltipUtils.getChance(utils, allConditions, rawChance);
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> countMap = TooltipUtils.getCount(utils, allFunctions);
        return EntryTooltipUtils.getTooltip(utils, entry.f_79676_, chanceMap, countMap, allFunctions, allConditions);
    }

    @NotNull
    public static List<ITooltipNode> getTooltip(IServerUtils utils, int quality, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
        tooltip.add(EntryTooltipUtils.getQualityTooltip(quality));
        tooltip.add(EntryTooltipUtils.getChanceTooltip(chance));
        tooltip.add(EntryTooltipUtils.getCountTooltip(count));
        tooltip.addAll(GenericTooltipUtils.getConditionsTooltip(utils, conditions));
        tooltip.addAll(GenericTooltipUtils.getFunctionsTooltip(utils, functions));
        return tooltip;
    }

    @NotNull
    public static @Unmodifiable ITooltipNode getQualityTooltip(int quality) {
        if (quality != 0) {
            return new TooltipNode(GenericTooltipUtils.translatable("ali.description.quality", GenericTooltipUtils.value(quality)));
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getChanceTooltip(Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        RangeValue defaultChance = chance.get(null).get(0);
        TooltipNode tooltip = !defaultChance.isRange() && (double)defaultChance.max() > 99.99999 ? new TooltipNode() : new TooltipNode(GenericTooltipUtils.translatable("ali.description.chance", GenericTooltipUtils.value(chance.get(null).get(0), "%")));
        for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceEntry : chance.entrySet()) {
            Holder<Enchantment> enchantment = chanceEntry.getKey();
            Map<Integer, RangeValue> levelMap = chanceEntry.getValue();
            if (enchantment == null) continue;
            for (Map.Entry<Integer, RangeValue> levelEntry : levelMap.entrySet()) {
                int level = levelEntry.getKey();
                RangeValue value = levelEntry.getValue();
                tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.description.chance_bonus", GenericTooltipUtils.value(value, "%"), GenericTooltipUtils.value(Component.m_237115_((String)((Enchantment)enchantment.m_203334_()).m_44704_())), GenericTooltipUtils.value(Component.m_237115_((String)("enchantment.level." + level))))));
            }
        }
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getCountTooltip(Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.description.count", GenericTooltipUtils.value(count.get(null).get(0))));
        for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceEntry : count.entrySet()) {
            Holder<Enchantment> enchantment = chanceEntry.getKey();
            Map<Integer, RangeValue> levelMap = chanceEntry.getValue();
            if (enchantment == null) continue;
            for (Map.Entry<Integer, RangeValue> levelEntry : levelMap.entrySet()) {
                int level = levelEntry.getKey();
                RangeValue value = levelEntry.getValue();
                tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.description.count_bonus", GenericTooltipUtils.value(value), GenericTooltipUtils.value(Component.m_237115_((String)((Enchantment)enchantment.m_203334_()).m_44704_())), GenericTooltipUtils.value(Component.m_237115_((String)("enchantment.level." + level))))));
            }
        }
        return tooltip;
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getBaseMap(float value) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> map = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        map.put(null, Map.of(0, new RangeValue(value)));
        return map;
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getBaseMap(float min, float max) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> map = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        map.put(null, Map.of(0, new RangeValue(min, max)));
        return map;
    }

    @NotNull
    public static ITooltipNode getRolls(RangeValue rolls, RangeValue bonusRolls) {
        return new TooltipNode(GenericTooltipUtils.translatable("ali.description.rolls", GenericTooltipUtils.value(EntryTooltipUtils.getTotalRolls(rolls, bonusRolls).toIntString(), "x")));
    }

    private static RangeValue getTotalRolls(RangeValue rolls, RangeValue bonusRolls) {
        if (bonusRolls.min() > 0.0f || bonusRolls.max() > 0.0f) {
            return new RangeValue(bonusRolls).add(rolls);
        }
        return rolls;
    }
}

