/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.common;

import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.QuadConsumer;
import com.yanny.ali.compatibility.common.TriConsumer;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.trades.TradeNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import oshi.util.tuples.Pair;

public class GenericUtils {
    private static final ResourceLocation TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int WIDGET_SIZE = 36;
    private static final int DOTS_WIDTH = Minecraft.getInstance().font.width("...");

    public static void renderEntity(Entity entity, Rect bounds, int fullWidth, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            guiGraphics.pose().pushMatrix();
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE_LOC, bounds.x(), bounds.y(), 0.0f, 36.0f, bounds.width(), bounds.height(), 36, 36, 256, 256);
            EntityDimensions dimensions = entity.getType().getDimensions();
            GenericUtils.renderEntityInInventoryFollowsMouse(guiGraphics, bounds.x() + 1, bounds.y() + 1, bounds.right() - 1, bounds.bottom() - 1, (int)Math.min(20.0f / dimensions.height(), 20.0f / dimensions.width()), 0.0625f, mouseX, mouseY, livingEntity);
            guiGraphics.pose().popMatrix();
        }
    }

    @NotNull
    public static Component ellipsis(String text, String fallback, int maxWidth) {
        Font font = Minecraft.getInstance().font;
        text = Language.getInstance().getOrDefault(text, GenericUtils.getFallbackText(fallback));
        if (font.width(text) > maxWidth) {
            int index = 20;
            while (font.width(text.substring(0, index + 1) + DOTS_WIDTH) <= maxWidth) {
                ++index;
            }
            return Component.literal((String)(text.substring(0, index) + "..."));
        }
        return Component.literal((String)text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Map<ResourceLocation, LootData>, Map<ResourceLocation, TradeData>> decompressLootData(byte[] fullCompressedData, RegistryAccess registryAccess) {
        HashMap<ResourceLocation, LootData> lootData = new HashMap<ResourceLocation, LootData>();
        HashMap<ResourceLocation, TradeData> tradeData = new HashMap<ResourceLocation, TradeData>();
        ByteArrayInputStream bis = new ByteArrayInputStream(fullCompressedData);
        ByteBuf decompressedBuf = Unpooled.buffer();
        try (GZIPInputStream gzip = new GZIPInputStream(bis);){
            decompressedBuf.writeBytes(gzip.readAllBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RegistryFriendlyByteBuf readerBuf = new RegistryFriendlyByteBuf(decompressedBuf, registryAccess);
        try {
            AliClientRegistry utils = PluginManager.CLIENT_REGISTRY;
            lootData.putAll(((ArrayList)readerBuf.readCollection(ArrayList::new, b -> {
                ResourceLocation location = b.readResourceLocation();
                Object dataNode = utils.getDataNodeFactory(LootTableNode.ID).create(utils, (RegistryFriendlyByteBuf)b);
                List items = (List)ItemStack.OPTIONAL_LIST_STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)b));
                return new AbstractMap.SimpleEntry<ResourceLocation, LootData>(location, new LootData((IDataNode)dataNode, items));
            })).stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            tradeData.putAll(((ArrayList)readerBuf.readCollection(ArrayList::new, b -> {
                ResourceLocation location = b.readResourceLocation();
                Object dataNode = utils.getDataNodeFactory(TradeNode.ID).create(utils, (RegistryFriendlyByteBuf)b);
                List<Item> inputs = ((ArrayList)b.readCollection(ArrayList::new, FriendlyByteBuf::readResourceLocation)).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getValue(arg_0)).toList();
                List<Item> outputs = ((ArrayList)b.readCollection(ArrayList::new, FriendlyByteBuf::readResourceLocation)).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getValue(arg_0)).toList();
                return new AbstractMap.SimpleEntry<ResourceLocation, TradeData>(location, new TradeData((IDataNode)dataNode, inputs, outputs));
            })).stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            Object dataNode = utils.getDataNodeFactory(TradeNode.ID).create(utils, readerBuf);
            List<Item> inputs = ((ArrayList)readerBuf.readCollection(ArrayList::new, FriendlyByteBuf::readResourceLocation)).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getValue(arg_0)).toList();
            List<Item> outputs = ((ArrayList)readerBuf.readCollection(ArrayList::new, FriendlyByteBuf::readResourceLocation)).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getValue(arg_0)).toList();
            tradeData.put(ResourceLocation.withDefaultNamespace((String)"empty"), new TradeData((IDataNode)dataNode, inputs, outputs));
        }
        finally {
            readerBuf.release();
        }
        return new Pair(lootData, tradeData);
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int size, float scale, float mouseX, float mouseY, LivingEntity entity) {
        float hCenter = (float)(left + right) / 2.0f;
        float vCenter = (float)(top + bottom) / 2.0f;
        float xRotation = (float)Math.atan((hCenter - mouseX) / 40.0f);
        float yRotation = (float)Math.atan((vCenter - mouseY) / 40.0f);
        float yBodyRot = entity.yBodyRot;
        float entityYRot = entity.getYRot();
        float entityXRot = entity.getXRot();
        float yHeadRotO = entity.yHeadRotO;
        float yHeadRot = entity.yHeadRot;
        Quaternionf rotateZ = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf rotateX = new Quaternionf().rotateX(yRotation * 20.0f * ((float)Math.PI / 180));
        rotateZ.mul((Quaternionfc)rotateX);
        guiGraphics.enableScissor(left, top, right, bottom);
        entity.yBodyRot = 180.0f + xRotation * 20.0f;
        entity.setYRot(180.0f + xRotation * 40.0f);
        entity.setXRot(-yRotation * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        float entityScale = entity.getScale();
        Vector3f $$22 = new Vector3f(0.0f, entity.getBbHeight() / 2.0f + scale * entityScale, 0.0f);
        float $$23 = (float)size / entityScale;
        int x = (int)guiGraphics.pose().m20();
        int y = (int)guiGraphics.pose().m21();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (int)(left + x), (int)(top + y), (int)(right + x), (int)(bottom + y), (float)$$23, (Vector3f)$$22, (Quaternionf)rotateZ, (Quaternionf)rotateX, (LivingEntity)entity);
        entity.yBodyRot = yBodyRot;
        entity.setYRot(entityYRot);
        entity.setXRot(entityXRot);
        entity.yHeadRotO = yHeadRotO;
        entity.yHeadRot = yHeadRot;
        guiGraphics.disableScissor();
    }

    public static void processData(ClientLevel level, AliClientRegistry clientRegistry, AliConfig config, byte[] fullCompressedData, QuadConsumer<IDataNode, ResourceLocation, Block, List<ItemStack>> blockConsumer, QuadConsumer<IDataNode, ResourceLocation, EntityType<?>, List<ItemStack>> entityConsumer, TriConsumer<IDataNode, ResourceLocation, List<ItemStack>> gameplayConsumer, QuadConsumer<IDataNode, ResourceLocation, List<ItemStack>, List<ItemStack>> traderConsumer, QuadConsumer<IDataNode, ResourceLocation, List<ItemStack>, List<ItemStack>> wanderingTraderConsumer) {
        List<ItemStack> outputs;
        List<ItemStack> inputs;
        TradeData tradeEntry;
        ResourceLocation location;
        Pair<Map<ResourceLocation, LootData>, Map<ResourceLocation, TradeData>> pair = GenericUtils.decompressLootData(fullCompressedData, level.registryAccess());
        Map lootData = (Map)pair.getA();
        Map tradeData = (Map)pair.getB();
        for (Block block : BuiltInRegistries.BLOCK) {
            block.getLootTable().ifPresent(resourceKey -> {
                ResourceLocation location = resourceKey.location();
                LootData data = (LootData)lootData.get(location);
                if (data != null) {
                    blockConsumer.accept(data.node, location, block, data.items);
                    lootData.remove(location);
                }
            });
        }
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            if (config.disabledEntities.stream().anyMatch(f -> f.equals((Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType)))) {
                entityType.getDefaultLootTable().ifPresent(lootTableResourceKey -> lootData.remove(lootTableResourceKey.location()));
                continue;
            }
            List<Entity> list = clientRegistry.createEntities(entityType, (Level)level);
            for (Entity entity : list) {
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                mob.getLootTable().ifPresent(resourceKey -> {
                    ResourceLocation location = resourceKey.location();
                    LootData data = (LootData)lootData.get(location);
                    if (data != null) {
                        entityConsumer.accept(data.node, location, entityType, data.items);
                    }
                    lootData.remove(location);
                });
            }
        }
        for (Map.Entry entry : lootData.entrySet()) {
            gameplayConsumer.accept(((LootData)entry.getValue()).node, (ResourceLocation)entry.getKey(), ((LootData)entry.getValue()).items());
        }
        lootData.clear();
        List<Map.Entry> entries = BuiltInRegistries.VILLAGER_PROFESSION.entrySet().stream().sorted(Comparator.comparing(a -> ((ResourceKey)a.getKey()).location().getPath())).toList();
        for (Map.Entry entry : entries) {
            location = ((ResourceKey)entry.getKey()).location();
            tradeEntry = (TradeData)tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = tradeEntry.inputs.stream().map(Item::getDefaultInstance).toList();
            outputs = tradeEntry.outputs.stream().map(Item::getDefaultInstance).toList();
            traderConsumer.accept(tradeEntry.node, location, inputs, outputs);
            tradeData.remove(location);
        }
        for (Map.Entry entry : tradeData.entrySet()) {
            location = (ResourceLocation)entry.getKey();
            tradeEntry = (TradeData)tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = tradeEntry.inputs.stream().map(Item::getDefaultInstance).toList();
            outputs = tradeEntry.outputs.stream().map(Item::getDefaultInstance).toList();
            wanderingTraderConsumer.accept(tradeEntry.node, location, inputs, outputs);
        }
        tradeData.clear();
    }

    private static String getFallbackText(String fallback) {
        List pathSegments = Pattern.compile("/").splitAsStream(fallback).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        Collections.reverse(pathSegments);
        return pathSegments.stream().flatMap(segment -> Arrays.stream(segment.split("_"))).filter(s -> !s.isEmpty()).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" "));
    }

    public record TradeData(IDataNode node, List<Item> inputs, List<Item> outputs) {
    }

    public record LootData(IDataNode node, List<ItemStack> items) {
    }
}

