/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.plugin.client.widget.TextureWidget;
import com.yanny.ali.plugin.common.NodeUtils;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_7836;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class WidgetUtils {
    public static final class_2960 TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int GROUP_WIDGET_WIDTH = 7;
    private static final int GROUP_WIDGET_HEIGHT = 18;

    @NotNull
    public static IWidget getAllWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 0, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getRandomWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 7, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getSequentialWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 14, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getAlternativesWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 21, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getDynamicWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 28, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getUnknownWidget(RelativeRect rect, IDataNode node) {
        return new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 18, 18, rect), 30, 0);
    }

    @NotNull
    public static IWidget getMissingWidget(RelativeRect rect) {
        return new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 18, 18, rect), 48, 0);
    }

    @NotNull
    public static IWidget getEmptyWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 18, 18, rect), 66, 0);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getArrowWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 24, 18, rect), 53, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getLevelWidget(RelativeRect rect, IDataNode node, int level) {
        final RelativeRect r = new RelativeRect(0, 0, 18, 18, rect);
        final List<class_2561> components = NodeUtils.toComponents(node.getTooltip(), 0, class_310.method_1551().field_1690.field_1827);
        final String txt = Integer.toString(level);
        final int txtWidth = class_310.method_1551().field_1772.method_1727(txt);
        return new IWidget(){

            @Override
            public RelativeRect getRect() {
                return r;
            }

            @Override
            public WidgetDirection getDirection() {
                return WidgetDirection.VERTICAL;
            }

            @Override
            public List<class_2561> getTooltipComponents(int mouseX, int mouseY) {
                return components;
            }

            @Override
            public void render(class_332 guiGraphics, int mouseX, int mouseY) {
                WidgetUtils.blitNineSliced(guiGraphics, TEXTURE_LOC, r.getX(), r.getY(), r.width, r.height, 2, 2, 2, 2, 18, 18, 35, 18);
                guiGraphics.method_51433(class_310.method_1551().field_1772, txt, r.getX() + (r.width - txtWidth) / 2, r.getY() + 9, 0, false);
            }
        };
    }

    public static void blit(class_332 guiGraphics, class_2960 pAtlasLocation, int pX, int pY, int pWidth, int pHeight, float pUOffset, float pVOffset, int pUWidth, int pVHeight) {
        guiGraphics.method_25302(class_1921::method_62277, pAtlasLocation, pX, pY, pUOffset, pVOffset, pWidth, pHeight, pUWidth, pVHeight, 255, 255);
    }

    public static void blit(class_332 guiGraphics, class_2960 pAtlasLocation, int pX, int pY, float pUOffset, float pVOffset, int pWidth, int pHeight) {
        WidgetUtils.blit(guiGraphics, pAtlasLocation, pX, pY, pWidth, pHeight, pUOffset, pVOffset, pWidth, pHeight);
    }

    public static void blitRepeating(class_332 guiGraphics, class_2960 pAtlasLocation, int pTargetX, int pTargetY, int pTargetWidth, int pTargetHeight, int pSourceX, int pSourceY, int pSourceWidth, int pSourceHeight) {
        int i = pTargetX;
        IntIterator intiterator = WidgetUtils.slices(pTargetWidth, pSourceWidth);
        while (intiterator.hasNext()) {
            int j = intiterator.nextInt();
            int k = (pSourceWidth - j) / 2;
            int l = pTargetY;
            IntIterator intiterator1 = WidgetUtils.slices(pTargetHeight, pSourceHeight);
            while (intiterator1.hasNext()) {
                int i1 = intiterator1.nextInt();
                int j1 = (pSourceHeight - i1) / 2;
                WidgetUtils.blit(guiGraphics, pAtlasLocation, i, l, pSourceX + k, pSourceY + j1, j, i1);
                l += i1;
            }
            i += j;
        }
    }

    public static void blitNineSliced(class_332 guiGraphics, class_2960 pAtlasLocation, int pTargetX, int pTargetY, int pTargetWidth, int pTargetHeight, int pCornerWidth, int pCornerHeight, int pEdgeWidth, int pEdgeHeight, int pSourceWidth, int pSourceHeight, int pSourceX, int pSourceY) {
        pCornerWidth = Math.min(pCornerWidth, pTargetWidth / 2);
        pEdgeWidth = Math.min(pEdgeWidth, pTargetWidth / 2);
        pCornerHeight = Math.min(pCornerHeight, pTargetHeight / 2);
        pEdgeHeight = Math.min(pEdgeHeight, pTargetHeight / 2);
        if (pTargetWidth == pSourceWidth && pTargetHeight == pSourceHeight) {
            WidgetUtils.blit(guiGraphics, pAtlasLocation, pTargetX, pTargetY, pSourceX, pSourceY, pTargetWidth, pTargetHeight);
        } else if (pTargetHeight == pSourceHeight) {
            WidgetUtils.blit(guiGraphics, pAtlasLocation, pTargetX, pTargetY, pSourceX, pSourceY, pCornerWidth, pTargetHeight);
            WidgetUtils.blitRepeating(guiGraphics, pAtlasLocation, pTargetX + pCornerWidth, pTargetY, pTargetWidth - pEdgeWidth - pCornerWidth, pTargetHeight, pSourceX + pCornerWidth, pSourceY, pSourceWidth - pEdgeWidth - pCornerWidth, pSourceHeight);
            WidgetUtils.blit(guiGraphics, pAtlasLocation, pTargetX + pTargetWidth - pEdgeWidth, pTargetY, pSourceX + pSourceWidth - pEdgeWidth, pSourceY, pEdgeWidth, pTargetHeight);
        } else if (pTargetWidth == pSourceWidth) {
            WidgetUtils.blit(guiGraphics, pAtlasLocation, pTargetX, pTargetY, pSourceX, pSourceY, pTargetWidth, pCornerHeight);
            WidgetUtils.blitRepeating(guiGraphics, pAtlasLocation, pTargetX, pTargetY + pCornerHeight, pTargetWidth, pTargetHeight - pEdgeHeight - pCornerHeight, pSourceX, pSourceY + pCornerHeight, pSourceWidth, pSourceHeight - pEdgeHeight - pCornerHeight);
            WidgetUtils.blit(guiGraphics, pAtlasLocation, pTargetX, pTargetY + pTargetHeight - pEdgeHeight, pSourceX, pSourceY + pSourceHeight - pEdgeHeight, pTargetWidth, pEdgeHeight);
        } else {
            WidgetUtils.blit(guiGraphics, pAtlasLocation, pTargetX, pTargetY, pSourceX, pSourceY, pCornerWidth, pCornerHeight);
            WidgetUtils.blitRepeating(guiGraphics, pAtlasLocation, pTargetX + pCornerWidth, pTargetY, pTargetWidth - pEdgeWidth - pCornerWidth, pCornerHeight, pSourceX + pCornerWidth, pSourceY, pSourceWidth - pEdgeWidth - pCornerWidth, pCornerHeight);
            WidgetUtils.blit(guiGraphics, pAtlasLocation, pTargetX + pTargetWidth - pEdgeWidth, pTargetY, pSourceX + pSourceWidth - pEdgeWidth, pSourceY, pEdgeWidth, pCornerHeight);
            WidgetUtils.blit(guiGraphics, pAtlasLocation, pTargetX, pTargetY + pTargetHeight - pEdgeHeight, pSourceX, pSourceY + pSourceHeight - pEdgeHeight, pCornerWidth, pEdgeHeight);
            WidgetUtils.blitRepeating(guiGraphics, pAtlasLocation, pTargetX + pCornerWidth, pTargetY + pTargetHeight - pEdgeHeight, pTargetWidth - pEdgeWidth - pCornerWidth, pEdgeHeight, pSourceX + pCornerWidth, pSourceY + pSourceHeight - pEdgeHeight, pSourceWidth - pEdgeWidth - pCornerWidth, pEdgeHeight);
            WidgetUtils.blit(guiGraphics, pAtlasLocation, pTargetX + pTargetWidth - pEdgeWidth, pTargetY + pTargetHeight - pEdgeHeight, pSourceX + pSourceWidth - pEdgeWidth, pSourceY + pSourceHeight - pEdgeHeight, pEdgeWidth, pEdgeHeight);
            WidgetUtils.blitRepeating(guiGraphics, pAtlasLocation, pTargetX, pTargetY + pCornerHeight, pCornerWidth, pTargetHeight - pEdgeHeight - pCornerHeight, pSourceX, pSourceY + pCornerHeight, pCornerWidth, pSourceHeight - pEdgeHeight - pCornerHeight);
            WidgetUtils.blitRepeating(guiGraphics, pAtlasLocation, pTargetX + pCornerWidth, pTargetY + pCornerHeight, pTargetWidth - pEdgeWidth - pCornerWidth, pTargetHeight - pEdgeHeight - pCornerHeight, pSourceX + pCornerWidth, pSourceY + pCornerHeight, pSourceWidth - pEdgeWidth - pCornerWidth, pSourceHeight - pEdgeHeight - pCornerHeight);
            WidgetUtils.blitRepeating(guiGraphics, pAtlasLocation, pTargetX + pTargetWidth - pEdgeWidth, pTargetY + pCornerHeight, pCornerWidth, pTargetHeight - pEdgeHeight - pCornerHeight, pSourceX + pSourceWidth - pEdgeWidth, pSourceY + pCornerHeight, pEdgeWidth, pSourceHeight - pEdgeHeight - pCornerHeight);
        }
    }

    public static void innerBlit(class_4588 consumer, Matrix4f matrix, int xStart, int xEnd, int yStart, int yEnd, int z, int width, int height, float u, float v, int texWidth, int texHeight) {
        WidgetUtils.innerBlit(consumer, matrix, xStart, xEnd, yStart, yEnd, z, u / (float)texWidth, (u + (float)width) / (float)texWidth, v / (float)texHeight, (v + (float)height) / (float)texHeight);
    }

    private static void innerBlit(class_4588 consumer, Matrix4f matrix, int xStart, int xEnd, int yStart, int yEnd, int z, float uStart, float uEnd, float vStart, float vEnd) {
        consumer.method_22918(matrix, (float)xStart, (float)yEnd, (float)z).method_22913(uStart, vEnd).method_39415(-1);
        consumer.method_22918(matrix, (float)xEnd, (float)yEnd, (float)z).method_22913(uEnd, vEnd).method_39415(-1);
        consumer.method_22918(matrix, (float)xEnd, (float)yStart, (float)z).method_22913(uEnd, vStart).method_39415(-1);
        consumer.method_22918(matrix, (float)xStart, (float)yStart, (float)z).method_22913(uStart, vStart).method_39415(-1);
    }

    @NotNull
    private static IntIterator slices(int p_282197_, int p_282161_) {
        int i = class_3532.method_38788((int)p_282197_, (int)p_282161_);
        return new class_7836(p_282197_, i);
    }
}

