/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.common.TradeLootType;
import com.yanny.ali.compatibility.rei.ReiBaseCategory;
import com.yanny.ali.compatibility.rei.ReiBaseDisplay;
import com.yanny.ali.compatibility.rei.ReiBlockCategory;
import com.yanny.ali.compatibility.rei.ReiBlockDisplay;
import com.yanny.ali.compatibility.rei.ReiEntityCategory;
import com.yanny.ali.compatibility.rei.ReiEntityDisplay;
import com.yanny.ali.compatibility.rei.ReiGameplayCategory;
import com.yanny.ali.compatibility.rei.ReiGameplayDisplay;
import com.yanny.ali.compatibility.rei.ReiTradeCategory;
import com.yanny.ali.compatibility.rei.ReiTradeDisplay;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReasons;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ReiCompatibility
implements REIClientPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<LootCategory<class_2248>, Holder<ReiBlockDisplay, BlockLootType, class_2248>> blockCategories = new LinkedHashMap<LootCategory<class_2248>, Holder<ReiBlockDisplay, BlockLootType, class_2248>>();
    private final Map<LootCategory<class_1299<?>>, Holder<ReiEntityDisplay, EntityLootType, class_1299<?>>> entityCategories = new LinkedHashMap();
    private final Map<LootCategory<class_2960>, Holder<ReiGameplayDisplay, GameplayLootType, class_2960>> gameplayCategories = new LinkedHashMap<LootCategory<class_2960>, Holder<ReiGameplayDisplay, GameplayLootType, class_2960>>();
    private final Map<LootCategory<class_2960>, Holder<ReiTradeDisplay, TradeLootType, class_2960>> tradeCategories = new LinkedHashMap<LootCategory<class_2960>, Holder<ReiTradeDisplay, TradeLootType, class_2960>>();

    public void registerCategories(CategoryRegistry registry) {
        AliConfig config = PluginManager.COMMON_REGISTRY.getConfiguration();
        this.blockCategories.clear();
        this.entityCategories.clear();
        this.gameplayCategories.clear();
        this.tradeCategories.clear();
        this.blockCategories.putAll(config.blockCategories.stream().collect(ReiCompatibility.getCollector(ReiBlockDisplay::new, ReiBlockCategory::new)));
        this.entityCategories.putAll(config.entityCategories.stream().collect(ReiCompatibility.getCollector(ReiEntityDisplay::new, ReiEntityCategory::new)));
        this.gameplayCategories.putAll(config.gameplayCategories.stream().collect(ReiCompatibility.getCollector(ReiGameplayDisplay::new, ReiGameplayCategory::new)));
        this.tradeCategories.putAll(config.tradeCategories.stream().collect(ReiCompatibility.getCollector(ReiTradeDisplay::new, ReiTradeCategory::new)));
        for (Holder<ReiBlockDisplay, BlockLootType, class_2248> holder : this.blockCategories.values()) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.entityCategories.values()) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.gameplayCategories.values()) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.tradeCategories.values()) {
            registry.add(holder.category);
        }
    }

    public void registerDisplays(DisplayRegistry registry) {
        CompletableFuture<byte[]> futureData = PluginManager.CLIENT_REGISTRY.getCurrentDataFuture();
        if (futureData.isDone()) {
            LOGGER.info("Data already received, processing instantly.");
        } else {
            LOGGER.info("Blocking this thread until all data are received!");
        }
        try {
            byte[] fullCompressedData = futureData.get();
            this.registerData(registry, fullCompressedData);
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof TimeoutException) {
                futureData.cancel(true);
                PluginManager.CLIENT_REGISTRY.clearLootData();
                LOGGER.error("Failed to received data: Inactivity timeout occurred. Registration aborted!");
            } else {
                LOGGER.error("Failed to finish registering data with error {}", (Object)cause.getMessage());
                cause.printStackTrace();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.error("Failed to finish registering data with unexpected error {}", (Object)e.getMessage());
        }
    }

    private void registerData(DisplayRegistry registry, byte[] fullCompressedData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        AliConfig config = PluginManager.COMMON_REGISTRY.getConfiguration();
        class_638 level = class_310.method_1551().field_1687;
        LOGGER.info("Adding loot information to REI");
        if (level != null) {
            HashMap blockRecipeTypes = new HashMap();
            HashMap entityRecipeTypes = new HashMap();
            HashMap gameplayRecipeTypes = new HashMap();
            HashMap tradeRecipeTypes = new HashMap();
            GenericUtils.processData(level, clientRegistry, config, fullCompressedData, (node, location, block, outputs) -> {
                Holder<ReiBlockDisplay, BlockLootType, class_2248> recipeHolder = null;
                for (Holder<ReiBlockDisplay, BlockLootType, class_2248> holder : this.blockCategories.values()) {
                    if (!holder.category.getLootCategory().validate(block)) continue;
                    if (holder.category.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeHolder = holder;
                    break;
                }
                if (recipeHolder != null) {
                    blockRecipeTypes.computeIfAbsent(recipeHolder, b -> new LinkedList()).add(new BlockLootType((class_2248)block, (IDataNode)node, Collections.emptyList(), (List<class_1799>)outputs));
                }
            }, (node, location, entity, outputs) -> {
                Holder<ReiEntityDisplay, EntityLootType, class_1299<?>> recipeHolder = null;
                for (Holder<ReiEntityDisplay, EntityLootType, class_1299<?>> holder : this.entityCategories.values()) {
                    if (!holder.category.getLootCategory().validate(entity)) continue;
                    if (holder.category.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeHolder = holder;
                    break;
                }
                if (recipeHolder != null) {
                    entityRecipeTypes.computeIfAbsent(recipeHolder, b -> new LinkedList()).add(new EntityLootType((class_1299<?>)entity, (class_2960)location, (IDataNode)node, Collections.emptyList(), (List<class_1799>)outputs));
                }
            }, (node, location, outputs) -> {
                Holder<ReiGameplayDisplay, GameplayLootType, class_2960> recipeHolder = null;
                for (Holder<ReiGameplayDisplay, GameplayLootType, class_2960> holder : this.gameplayCategories.values()) {
                    if (!holder.category.getLootCategory().validate(location)) continue;
                    if (holder.category.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeHolder = holder;
                    break;
                }
                if (recipeHolder != null) {
                    gameplayRecipeTypes.computeIfAbsent(recipeHolder, b -> new LinkedList()).add(new GameplayLootType((IDataNode)node, location.method_12832(), Collections.emptyList(), (List<class_1799>)outputs));
                }
            }, (tradeEntry, location, inputs, outputs) -> {
                Holder<ReiTradeDisplay, TradeLootType, class_2960> recipeHolder = null;
                for (Holder<ReiTradeDisplay, TradeLootType, class_2960> holder : this.tradeCategories.values()) {
                    if (!holder.category.getLootCategory().validate(location)) continue;
                    if (holder.category.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeHolder = holder;
                    break;
                }
                if (recipeHolder != null) {
                    tradeRecipeTypes.computeIfAbsent(recipeHolder, b -> new LinkedList()).add(new TradeLootType((IDataNode)tradeEntry, location.method_12832(), (List<class_1799>)inputs, (List<class_1799>)outputs));
                }
            }, (tradeEntry, location, inputs, outputs) -> {
                Holder<ReiTradeDisplay, TradeLootType, class_2960> recipeHolder = null;
                for (Holder<ReiTradeDisplay, TradeLootType, class_2960> holder : this.tradeCategories.values()) {
                    if (!holder.category.getLootCategory().validate(location)) continue;
                    if (holder.category.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeHolder = holder;
                    break;
                }
                if (recipeHolder != null) {
                    tradeRecipeTypes.computeIfAbsent(recipeHolder, b -> new LinkedList()).add(new TradeLootType((IDataNode)tradeEntry, location.method_12832(), (List<class_1799>)inputs, (List<class_1799>)outputs));
                }
            });
            for (Map.Entry entry : blockRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.blockPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry entry : entityRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.entityPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry entry : gameplayRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.gameplayPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry entry : tradeRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.tradePredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
        } else {
            LOGGER.warn("REI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    private static <D extends ReiBaseDisplay, T, U> Holder<D, T, U> createCategory(LootCategory<U> lootCategory, BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, class_2561, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        CategoryIdentifier identifier = CategoryIdentifier.of((class_2960)lootCategory.getKey());
        class_5250 title = class_2561.method_43471((String)("emi.category." + lootCategory.getKey().method_12836() + "." + lootCategory.getKey().method_12832().replace('/', '.')));
        BiFunction<Object, DisplayAdditionReasons, ReiBaseDisplay> filler = (type, r) -> (ReiBaseDisplay)((Object)((Object)displayFactory.apply(type, identifier)));
        return new Holder(identifier, (ReiBaseCategory)categoryFactory.apply((Object)identifier, (Object)title, lootCategory), filler);
    }

    @NotNull
    private static <D extends ReiBaseDisplay, T, U> Collector<LootCategory<U>, ?, Map<LootCategory<U>, Holder<D, T, U>>> getCollector(BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, class_2561, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        return Collectors.toMap(e -> e, e -> ReiCompatibility.createCategory(e, displayFactory, categoryFactory), (a, b) -> a, LinkedHashMap::new);
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> blockPredicate(List<BlockLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof BlockLootType) {
                BlockLootType type = (BlockLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> entityPredicate(List<EntityLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof EntityLootType) {
                EntityLootType type = (EntityLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> gameplayPredicate(List<GameplayLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof GameplayLootType) {
                GameplayLootType type = (GameplayLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> tradePredicate(List<TradeLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof TradeLootType) {
                TradeLootType type = (TradeLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    private record Holder<D extends ReiBaseDisplay, T, U>(CategoryIdentifier<D> identifier, ReiBaseCategory<D, U> category, BiFunction<T, DisplayAdditionReasons, D> filler) {
    }
}

