/*
 * Decompiled with CFR 0.152.
 */
package com.capemod.handler;

import com.mojang.authlib.GameProfile;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CapeMod");
    public static final Map<String, class_2960> CAPES = new ConcurrentHashMap<String, class_2960>();
    public static final Map<String, Boolean> NO_CAPE_CACHE = new ConcurrentHashMap<String, Boolean>();

    public static void loadPlayerCape(GameProfile player, ReturnCapeTexture response) {
        String uuid = player.id().toString();
        if (NO_CAPE_CACHE.containsKey(uuid)) {
            response.response(null);
            return;
        }
        if (CAPES.containsKey(uuid)) {
            response.response(CAPES.get(uuid));
            return;
        }
        class_156.method_18349().execute(() -> {
            try {
                String urlString = String.format("https://textures.capemod.com/cape/?uuid=%s", uuid);
                class_1011 capeImage = PlayerHandler.getCapeFromURLImage(urlString);
                if (capeImage != null) {
                    class_310.method_1551().execute(() -> {
                        try {
                            class_2960 capeTextureId = class_2960.method_60655((String)"capemod", (String)("textures/cape_" + uuid.replace("-", "_") + ".png"));
                            class_1043 texture = new class_1043(() -> ((class_2960)capeTextureId).toString(), capeImage);
                            class_310.method_1551().method_1531().method_4616(capeTextureId, (class_1044)texture);
                            CAPES.put(uuid, capeTextureId);
                            response.response(capeTextureId);
                        }
                        catch (Exception e) {
                            NO_CAPE_CACHE.put(uuid, true);
                            response.response(null);
                        }
                    });
                } else {
                    NO_CAPE_CACHE.put(uuid, true);
                    response.response(null);
                }
            }
            catch (Exception e) {
                NO_CAPE_CACHE.put(uuid, true);
                response.response(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_1011 getCapeFromURLImage(String capeStringURL) {
        HttpURLConnection connection = null;
        InputStream stream = null;
        try {
            URL capeURL = new URI(capeStringURL).toURL();
            connection = (HttpURLConnection)capeURL.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("User-Agent", "Minecraft-CapeMod/1.0");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                class_1011 image;
                stream = connection.getInputStream();
                class_1011 class_10112 = image = class_1011.method_4309((InputStream)stream);
                return class_10112;
            }
            if (responseCode == 404) {
                class_1011 class_10113 = null;
                return class_10113;
            }
            class_1011 class_10114 = null;
            return class_10114;
        }
        catch (Exception e) {
            class_1011 class_10115 = null;
            return class_10115;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static class_2960 getCape(String uuid) {
        return CAPES.get(uuid);
    }

    public static interface ReturnCapeTexture {
        public void response(class_2960 var1);
    }
}

