/*
 * Decompiled with CFR 0.152.
 */
package com.capemod.handler;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class VersionCheck
implements ClientModInitializer {
    private static final String CURRENT_VERSION = "1.3.0";
    private static final String VERSION_URL = "https://api.capemod.com/v1/version/1.21.10.txt";
    private static final int TIMEOUT_SECONDS = 5;
    private boolean hasCheckedForUpdate = false;

    public void onInitializeClient() {
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                class_310 client = class_310.method_1551();
                class_746 player = client.field_1724;
                if (player != null && client.method_1558() != null && !VersionCheck.this.hasCheckedForUpdate) {
                    VersionCheck.this.hasCheckedForUpdate = true;
                    CompletableFuture.runAsync(VersionCheck.this::checkForUpdate);
                }
            }
        }, 0L, 5000L);
    }

    private void checkForUpdate() {
        try {
            String latestVersion = this.fetchLatestVersion();
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && !CURRENT_VERSION.trim().equals(latestVersion.trim())) {
                player.method_7353(class_2561.method_30163((String)("\u00a7a\u00a7l[CapeMod] \u00a7aA new version is available: " + latestVersion)), false);
            }
        }
        catch (Exception e) {
            System.err.println("Error on connection: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchLatestVersion() throws Exception {
        HttpURLConnection connection = null;
        try {
            String inputLine;
            URL url = new URL(VERSION_URL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(5L));
            connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(5L));
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            String string = content.toString().trim();
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

