/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.cs.core.api.events;

import com.easeon.cs.core.api.definitions.enums.EventPhase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4184;

@Environment(value=EnvType.CLIENT)
public class EaseonFovClient {
    private static final List<FovTask> _beforeTasks = new CopyOnWriteArrayList<FovTask>();
    private static final List<FovTask> _afterTasks = new CopyOnWriteArrayList<FovTask>();
    private static final Map<Object, FovTask> _methodRefTasks = new HashMap<Object, FovTask>();

    public static FovTask register(FovRunnable task) {
        return EaseonFovClient.register(EventPhase.AFTER, task);
    }

    public static FovTask register(EventPhase phase, FovRunnable task) {
        FovTask fovTask = new FovTask(phase, task);
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(fovTask);
        } else {
            _afterTasks.add(fovTask);
        }
        _methodRefTasks.put(task, fovTask);
        return fovTask;
    }

    public static void register(FovTask task) {
        List<FovTask> targetList;
        List<FovTask> list = targetList = task.getPhase() == EventPhase.BEFORE ? _beforeTasks : _afterTasks;
        if (!targetList.contains(task)) {
            targetList.add(task);
        }
    }

    public static void unregister(FovTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static void unregister(FovRunnable task) {
        FovTask fovTask = _methodRefTasks.remove(task);
        if (fovTask != null) {
            _beforeTasks.remove(fovTask);
            _afterTasks.remove(fovTask);
        }
    }

    public static float onFovBefore(class_4184 camera, float tickDelta, boolean changingFov, float originalFov) {
        return EaseonFovClient.executeTasks(_beforeTasks, camera, tickDelta, changingFov, originalFov, "BEFORE");
    }

    public static float onFovAfter(class_4184 camera, float tickDelta, boolean changingFov, float originalFov) {
        return EaseonFovClient.executeTasks(_afterTasks, camera, tickDelta, changingFov, originalFov, "AFTER");
    }

    public static float onFov(class_4184 camera, float tickDelta, boolean changingFov, float originalFov) {
        return EaseonFovClient.onFovAfter(camera, tickDelta, changingFov, originalFov);
    }

    private static float executeTasks(List<FovTask> tasks, class_4184 camera, float tickDelta, boolean changingFov, float currentFov, String phase) {
        float resultFov = currentFov;
        for (FovTask task : tasks) {
            try {
                float newFov = task.execute(camera, tickDelta, changingFov, resultFov);
                if (newFov == resultFov) continue;
                resultFov = newFov;
            }
            catch (Exception exception) {}
        }
        return resultFov;
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface FovRunnable {
        public float run(class_4184 var1, float var2, boolean var3, float var4);
    }

    @Environment(value=EnvType.CLIENT)
    public static class FovTask {
        private final EventPhase _phase;
        private final FovRunnable _task;

        public FovTask(EventPhase phase, FovRunnable task) {
            this._phase = phase;
            this._task = task;
        }

        public EventPhase getPhase() {
            return this._phase;
        }

        public float execute(class_4184 camera, float tickDelta, boolean changingFov, float originalFov) {
            return this._task.run(camera, tickDelta, changingFov, originalFov);
        }
    }
}

