/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.cs.core.api.events;

import com.easeon.cs.core.api.definitions.enums.EventPhase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class EaseonHudRenderClient {
    private static final List<HudRenderTask> _beforeTasks = new CopyOnWriteArrayList<HudRenderTask>();
    private static final List<HudRenderTask> _afterTasks = new CopyOnWriteArrayList<HudRenderTask>();
    private static final Map<Object, HudRenderTask> _methodRefTasks = new HashMap<Object, HudRenderTask>();

    public static HudRenderTask register(HudRenderRunnable task) {
        return EaseonHudRenderClient.register(EventPhase.AFTER, task);
    }

    public static HudRenderTask register(EventPhase phase, HudRenderRunnable task) {
        HudRenderTask hudRenderTask = new HudRenderTask(phase, task);
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(hudRenderTask);
        } else {
            _afterTasks.add(hudRenderTask);
        }
        _methodRefTasks.put(task, hudRenderTask);
        return hudRenderTask;
    }

    public static void register(HudRenderTask task) {
        List<HudRenderTask> targetList;
        List<HudRenderTask> list = targetList = task.getPhase() == EventPhase.BEFORE ? _beforeTasks : _afterTasks;
        if (!targetList.contains(task)) {
            targetList.add(task);
        }
    }

    public static void unregister(HudRenderTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static void unregister(HudRenderRunnable task) {
        HudRenderTask hudRenderTask = _methodRefTasks.remove(task);
        if (hudRenderTask != null) {
            _beforeTasks.remove(hudRenderTask);
            _afterTasks.remove(hudRenderTask);
        }
    }

    public static void onHudRenderBefore(class_332 drawContext, class_9779 tickCounter) {
        EaseonHudRenderClient.executeTasks(_beforeTasks, drawContext, tickCounter, "BEFORE");
    }

    public static void onHudRenderAfter(class_332 drawContext, class_9779 tickCounter) {
        EaseonHudRenderClient.executeTasks(_afterTasks, drawContext, tickCounter, "AFTER");
    }

    public static void onHudRender(class_332 drawContext, class_9779 tickCounter) {
        EaseonHudRenderClient.onHudRenderAfter(drawContext, tickCounter);
    }

    private static void executeTasks(List<HudRenderTask> tasks, class_332 drawContext, class_9779 tickCounter, String phase) {
        for (HudRenderTask task : tasks) {
            try {
                task.execute(drawContext, tickCounter);
            }
            catch (Exception exception) {}
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface HudRenderRunnable {
        public void run(class_332 var1, class_9779 var2);
    }

    @Environment(value=EnvType.CLIENT)
    public static class HudRenderTask {
        private final EventPhase _phase;
        private final HudRenderRunnable _task;

        public HudRenderTask(EventPhase phase, HudRenderRunnable task) {
            this._phase = phase;
            this._task = task;
        }

        public EventPhase getPhase() {
            return this._phase;
        }

        public void execute(class_332 drawContext, class_9779 tickCounter) {
            this._task.run(drawContext, tickCounter);
        }
    }
}

