/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.cs.core.api.events;

import com.easeon.cs.core.api.definitions.enums.EventPhase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class EaseonScreenInitClient {
    private static final List<ScreenInitTask> _beforeTasks = new CopyOnWriteArrayList<ScreenInitTask>();
    private static final List<ScreenInitTask> _afterTasks = new CopyOnWriteArrayList<ScreenInitTask>();
    private static final Map<Object, ScreenInitTask> _methodRefTasks = new HashMap<Object, ScreenInitTask>();

    public static ScreenInitTask register(ScreenInitRunnable task) {
        return EaseonScreenInitClient.register(EventPhase.AFTER, task);
    }

    public static ScreenInitTask register(EventPhase phase, ScreenInitRunnable task) {
        ScreenInitTask screenInitTask = new ScreenInitTask(phase, task);
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(screenInitTask);
        } else {
            _afterTasks.add(screenInitTask);
        }
        _methodRefTasks.put(task, screenInitTask);
        return screenInitTask;
    }

    public static void register(ScreenInitTask task) {
        List<ScreenInitTask> targetList;
        List<ScreenInitTask> list = targetList = task.getPhase() == EventPhase.BEFORE ? _beforeTasks : _afterTasks;
        if (!targetList.contains(task)) {
            targetList.add(task);
        }
    }

    public static void unregister(ScreenInitTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static void unregister(ScreenInitRunnable task) {
        ScreenInitTask screenInitTask = _methodRefTasks.remove(task);
        if (screenInitTask != null) {
            _beforeTasks.remove(screenInitTask);
            _afterTasks.remove(screenInitTask);
        }
    }

    public static void onScreenInitBefore(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        EaseonScreenInitClient.executeTasks(_beforeTasks, client, screen, scaledWidth, scaledHeight, "BEFORE");
    }

    public static void onScreenInitAfter(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        EaseonScreenInitClient.executeTasks(_afterTasks, client, screen, scaledWidth, scaledHeight, "AFTER");
    }

    public static void onScreenInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        EaseonScreenInitClient.onScreenInitAfter(client, screen, scaledWidth, scaledHeight);
    }

    private static void executeTasks(List<ScreenInitTask> tasks, class_310 client, class_437 screen, int scaledWidth, int scaledHeight, String phase) {
        for (ScreenInitTask task : tasks) {
            try {
                task.execute(client, screen, scaledWidth, scaledHeight);
            }
            catch (Exception exception) {}
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ScreenInitRunnable {
        public void run(class_310 var1, class_437 var2, int var3, int var4);
    }

    @Environment(value=EnvType.CLIENT)
    public static class ScreenInitTask {
        private final EventPhase _phase;
        private final ScreenInitRunnable _task;

        public ScreenInitTask(EventPhase phase, ScreenInitRunnable task) {
            this._phase = phase;
            this._task = task;
        }

        public EventPhase getPhase() {
            return this._phase;
        }

        public void execute(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
            this._task.run(client, screen, scaledWidth, scaledHeight);
        }
    }
}

