/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.cs.core.api.events;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class EaseonKeyBindClient {
    private static final List<KeyBindTask> _tasks = new CopyOnWriteArrayList<KeyBindTask>();
    private static final Map<Object, KeyBindTask> _methodRefTasks = new HashMap<Object, KeyBindTask>();

    public static KeyBindTask register(KeyBindRunnable task) {
        KeyBindTask keyBindTask = new KeyBindTask(task);
        _tasks.add(keyBindTask);
        _methodRefTasks.put(task, keyBindTask);
        return keyBindTask;
    }

    public static void register(KeyBindTask task) {
        if (!_tasks.contains(task)) {
            _tasks.add(task);
        }
    }

    public static void unregister(KeyBindTask task) {
        _tasks.remove(task);
    }

    public static void unregister(KeyBindRunnable task) {
        KeyBindTask keyBindTask = _methodRefTasks.remove(task);
        if (keyBindTask != null) {
            _tasks.remove(keyBindTask);
        }
    }

    public static void onEndClientTick(class_310 client) {
        EaseonKeyBindClient.executeTasks(_tasks, client);
    }

    private static void executeTasks(List<KeyBindTask> tasks, class_310 client) {
        for (KeyBindTask task : tasks) {
            try {
                task.execute(client);
            }
            catch (Exception exception) {}
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class KeyBindTask {
        private final KeyBindRunnable _task;

        public KeyBindTask(KeyBindRunnable task) {
            this._task = task;
        }

        public void execute(class_310 client) {
            this._task.run(client);
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface KeyBindRunnable {
        public void run(class_310 var1);
    }
}

