/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.cs.core.config;

import com.easeon.cs.core.api.EaseonFeatureType;
import com.easeon.cs.core.config.model.FeatureStruct;
import com.easeon.cs.core.config.model.HotkeyConfig;
import com.easeon.cs.core.config.model.SliderConfig;
import com.easeon.cs.core.config.model.ToggleConfig;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class EaseonConfig {
    private static final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    public static final Map<EaseonFeatureType, FeatureStruct> configMap = new LinkedHashMap<EaseonFeatureType, FeatureStruct>();
    private static File CONFIG_FILE;
    public static String modName;
    public static String configFileName;
    private static final Logger LOGGER;

    public static void init(String modName, String configFileName) {
        EaseonConfig.modName = modName;
        EaseonConfig.configFileName = configFileName;
        CONFIG_FILE = new File(configFileName);
    }

    public static void load() {
        try {
            ObjectNode root = mapper.createObjectNode();
            if (CONFIG_FILE.exists()) {
                root = (ObjectNode)mapper.readTree(CONFIG_FILE);
            }
            for (EaseonFeatureType type : EaseonFeatureType.values()) {
                FeatureStruct struct;
                if (root.has(type.getId())) {
                    struct = (FeatureStruct)mapper.treeToValue((TreeNode)root.get(type.getId()), type.getStructClass());
                    struct.applyDefaults();
                } else {
                    FeatureStruct defaultStruct = type.createDefault();
                    try {
                        String json = mapper.writeValueAsString((Object)defaultStruct);
                        struct = (FeatureStruct)mapper.readValue(json, type.getStructClass());
                    }
                    catch (Exception e) {
                        struct = defaultStruct;
                    }
                }
                configMap.put(type, struct);
            }
        }
        catch (Exception e) {
            System.err.println("[Easeon] \uc124\uc815 \ub85c\ub4dc \uc2e4\ud328: " + e.getMessage());
        }
    }

    public static void save() {
        try {
            File parent = CONFIG_FILE.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            ObjectNode root = mapper.createObjectNode();
            for (EaseonFeatureType type : EaseonFeatureType.values()) {
                FeatureStruct val = configMap.get(type);
                if (val == null) continue;
                root.set(type.getId(), mapper.valueToTree((Object)val));
            }
            Files.write(CONFIG_FILE.toPath(), mapper.writeValueAsBytes((Object)root), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("[Easeon] \uc124\uc815 \uc800\uc7a5 \uc2e4\ud328: " + e.getMessage());
        }
    }

    public static boolean hasAnyNonDefault() {
        for (Map.Entry<EaseonFeatureType, FeatureStruct> entry : configMap.entrySet()) {
            if (!entry.getKey().isChanged(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean allDefault() {
        return !EaseonConfig.hasAnyNonDefault();
    }

    public static void reset(EaseonFeatureType type) {
        Field[] fields;
        LOGGER.info("[Easeon] reset: {}", (Object)type.getId());
        FeatureStruct target = configMap.get(type);
        if (target == null) {
            return;
        }
        LOGGER.info("[Easeon] reset: {}", (Object)target.getClass().getName());
        FeatureStruct defaults = type.createDefault();
        for (Field f : fields = target.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            try {
                Object defaultVal = f.get(defaults);
                f.set(target, defaultVal);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to reset field " + f.getName(), e);
            }
        }
    }

    public static void resetAll() {
        for (EaseonFeatureType type : EaseonFeatureType.values()) {
            EaseonConfig.reset(type);
        }
    }

    public static SliderConfig getSliderConfig(EaseonFeatureType type) {
        FeatureStruct val = configMap.get(type);
        if (val instanceof SliderConfig) {
            SliderConfig sc = (SliderConfig)val;
            return sc;
        }
        if (val != null) {
            LOGGER.warn("[Easeon] Type mismatch: {} is not a SliderConfig (actual: {})", (Object)type.getId(), (Object)val.getClass().getSimpleName());
        }
        return null;
    }

    public static ToggleConfig getToggleConfig(EaseonFeatureType type) {
        FeatureStruct val = configMap.get(type);
        if (val instanceof ToggleConfig) {
            ToggleConfig tc = (ToggleConfig)val;
            return tc;
        }
        if (val != null) {
            LOGGER.warn("[Easeon] Type mismatch: {} is not a ToggleConfig (actual: {})", (Object)type.getId(), (Object)val.getClass().getSimpleName());
        }
        return null;
    }

    public static HotkeyConfig getHotkeyConfig(EaseonFeatureType type) {
        FeatureStruct val = configMap.get(type);
        if (val instanceof HotkeyConfig) {
            HotkeyConfig hc = (HotkeyConfig)val;
            return hc;
        }
        if (val != null) {
            LOGGER.warn("[Easeon] Type mismatch: {} is not a HotkeyConfig (actual: {})", (Object)type.getId(), (Object)val.getClass().getSimpleName());
        }
        return null;
    }

    static {
        modName = "";
        configFileName = "";
        LOGGER = LogManager.getLogger((String)"Easeon");
    }
}

