/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.cs.core.gui.views;

import com.easeon.cs.core.gui.common.GuiRenderable;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class ScrollView {
    private static final Logger LOGGER = LogManager.getLogger((String)"Easeon");
    public final int x1;
    public final int x2;
    public final int y1;
    public final int y2;
    public final int height;
    public int contentHeight = 0;
    public int scrollBarY = 0;
    public int scrollBarHeight = 0;
    public float scrollOffset = 0.0f;
    public int dragClickOffset = 0;
    public boolean isDragging = false;
    public int trackX1;

    public ScrollView(List<GuiRenderable> scissorWidgets) {
        int w = class_310.method_1551().method_22683().method_4486();
        int h = class_310.method_1551().method_22683().method_4502();
        this.x1 = 5;
        this.x2 = w - 90 - 10;
        this.y1 = 27;
        this.y2 = h - 5 - 2;
        this.height = this.y2 - this.y1;
        this.trackX1 = this.x2 - 6;
        int widgetCount = scissorWidgets.size();
        int widgetHeight = 22;
        this.contentHeight = widgetCount * widgetHeight + 10 - 2;
        this.contentHeight = Math.max(this.contentHeight, this.height);
        LOGGER.info("contentHeight: {}, widgetCount: {}", (Object)this.contentHeight, (Object)widgetCount);
    }

    public boolean isOverScrollBar(double mouseX, double mouseY) {
        if (this.isScrollbarHidden()) {
            return false;
        }
        boolean inX = mouseX >= (double)this.trackX1 && mouseX < (double)this.x2;
        boolean inY = mouseY >= (double)this.scrollBarY && mouseY < (double)(this.scrollBarY + this.scrollBarHeight);
        return inX && inY;
    }

    public boolean isScrollbarHidden() {
        return this.contentHeight <= this.height;
    }

    public void updateScrollBarMetrics() {
        if (this.isScrollbarHidden()) {
            return;
        }
        this.scrollBarHeight = Math.max((int)((float)this.height * ((float)this.height / (float)this.contentHeight)), 10);
        float scrollRatio = class_3532.method_15363((float)(this.scrollOffset / (float)(this.contentHeight - this.height)), (float)0.0f, (float)1.0f);
        this.scrollBarY = this.y1 + (int)((float)(this.height - this.scrollBarHeight) * scrollRatio);
    }

    public int getMaxScrollOffset() {
        return Math.max(0, this.contentHeight - this.height);
    }

    public void scrollBy(float amount) {
        this.scrollOffset = class_3532.method_15363((float)(this.scrollOffset - amount), (float)0.0f, (float)this.getMaxScrollOffset());
    }

    public void scrollToRatio(float ratio) {
        ratio = class_3532.method_15363((float)ratio, (float)0.0f, (float)1.0f);
        this.scrollOffset = (float)this.getMaxScrollOffset() * ratio;
    }

    public float getScrollRatioFromMouse(double mouseY) {
        return (float)((mouseY - (double)this.y1 - (double)this.dragClickOffset) / (double)(this.height - this.scrollBarHeight));
    }

    public void beginDragging(double mouseY) {
        this.isDragging = true;
        this.dragClickOffset = (int)mouseY - this.scrollBarY;
    }

    public void endDragging() {
        this.isDragging = false;
    }

    public int getWidth() {
        return this.x2 - this.x1;
    }
}

