/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.cs.core;

import com.easeon.cs.core.api.EaseonFeatureCategory;
import com.easeon.cs.core.api.EaseonFeatureEnumLike;
import com.easeon.cs.core.api.EaseonFeatureSubCategory;
import com.easeon.cs.core.api.EaseonFeatureType;
import com.easeon.cs.core.config.EaseonConfig;
import com.easeon.cs.core.config.model.HotkeyConfig;
import com.easeon.cs.core.config.model.SliderConfig;
import com.easeon.cs.core.config.model.ToggleConfig;
import com.easeon.cs.core.gui.EaseonScreen;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class EaseonClientCore {
    private EaseonClientCore() {
    }

    public static EaseonCategoryBuilder init(String modName, String configPath) {
        if (modName == null || modName.trim().isEmpty()) {
            throw new IllegalArgumentException("Mod ID cannot be null, empty, or whitespace.");
        }
        if (configPath == null || configPath.trim().isEmpty()) {
            throw new IllegalArgumentException("Config path cannot be null, empty, or whitespace.");
        }
        EaseonConfig.init(modName, configPath);
        return new EaseonCategoryBuilder(new EaseonClientCore());
    }

    public static class_437 getSettingsScreen() {
        return new EaseonScreen();
    }

    public static void openSettingsScreen() {
        class_310 client = class_310.method_1551();
        client.execute(() -> client.method_1507(EaseonClientCore.getSettingsScreen()));
    }

    public static SliderConfig getSliderConfig(EaseonFeatureEnumLike feature) {
        return EaseonConfig.getSliderConfig(EaseonFeatureType.valueOf(feature.id().toLowerCase()));
    }

    public static ToggleConfig getToggleConfig(EaseonFeatureEnumLike feature) {
        return EaseonConfig.getToggleConfig(EaseonFeatureType.valueOf(feature.id().toLowerCase()));
    }

    public static HotkeyConfig getHotkeyConfig(EaseonFeatureEnumLike feature) {
        return EaseonConfig.getHotkeyConfig(EaseonFeatureType.valueOf(feature.id().toLowerCase()));
    }

    public EaseonCategoryBuilder category(String id, String title) {
        EaseonFeatureCategory category = EaseonFeatureCategory.register(id, title);
        return new EaseonCategoryBuilder(this, category);
    }

    @Environment(value=EnvType.CLIENT)
    public static class EaseonCategoryBuilder {
        private final EaseonClientCore core;
        private final EaseonFeatureCategory category;

        public EaseonCategoryBuilder(EaseonClientCore core) {
            this.core = core;
            this.category = null;
        }

        public EaseonCategoryBuilder(EaseonClientCore core, EaseonFeatureCategory category) {
            this.core = core;
            this.category = category;
        }

        public EaseonSubCategoryBuilder section(String id, String title) {
            EaseonFeatureSubCategory sub = EaseonFeatureSubCategory.register(id, title);
            return new EaseonSubCategoryBuilder(this.core, this.category, sub);
        }

        public EaseonCategoryBuilder category(String id, String title) {
            return this.core.category(id, title);
        }

        public void build() {
            EaseonConfig.load();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class EaseonSubCategoryBuilder {
        private final EaseonClientCore core;
        private final EaseonFeatureCategory category;
        private final EaseonFeatureSubCategory subCategory;

        public EaseonSubCategoryBuilder(EaseonClientCore core, EaseonFeatureCategory category, EaseonFeatureSubCategory subCategory) {
            this.core = core;
            this.category = category;
            this.subCategory = subCategory;
        }

        public EaseonSubCategoryBuilder slider(String id, String name, Supplier<SliderConfig> supplier, int min, int max, String ValueFormat) {
            EaseonFeatureType.registerSlider(id.toLowerCase(), name, this.category, this.subCategory, supplier, min, max, ValueFormat);
            return this;
        }

        public EaseonSubCategoryBuilder toggle(String id, String name, Supplier<ToggleConfig> supplier) {
            EaseonFeatureType.registerToggle(id.toLowerCase(), name, this.category, this.subCategory, supplier);
            return this;
        }

        public EaseonSubCategoryBuilder hotkey(String id, String name, Supplier<HotkeyConfig> supplier) {
            EaseonFeatureType.registerHotkey(id.toLowerCase(), name, this.category, this.subCategory, supplier);
            return this;
        }

        public EaseonSubCategoryBuilder slider(EaseonFeatureEnumLike feature) {
            return this.slider(feature.id(), feature.title(), () -> (SliderConfig)feature.getDefaultConfig(), feature.getMin(), feature.getMax(), feature.getValueFormat());
        }

        public EaseonSubCategoryBuilder toggle(EaseonFeatureEnumLike feature) {
            return this.toggle(feature.id(), feature.title(), () -> (ToggleConfig)feature.getDefaultConfig());
        }

        public EaseonSubCategoryBuilder hotkey(EaseonFeatureEnumLike feature) {
            return this.hotkey(feature.id(), feature.title(), () -> (HotkeyConfig)feature.getDefaultConfig());
        }

        public EaseonSubCategoryBuilder section(String id, String title) {
            EaseonFeatureSubCategory sub = EaseonFeatureSubCategory.register(id, title);
            return new EaseonSubCategoryBuilder(this.core, this.category, sub);
        }

        public EaseonCategoryBuilder category(String id, String title) {
            return this.core.category(id, title);
        }

        public void build() {
            EaseonConfig.load();
        }
    }
}

