/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.cs.core.api;

import com.easeon.cs.core.api.EaseonFeatureCategory;
import com.easeon.cs.core.api.EaseonFeatureSubCategory;
import com.easeon.cs.core.config.model.FeatureStruct;
import com.easeon.cs.core.config.model.HotkeyConfig;
import com.easeon.cs.core.config.model.SliderConfig;
import com.easeon.cs.core.config.model.ToggleConfig;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public final class EaseonFeatureType {
    private final String id;
    private final String title;
    private final Class<? extends FeatureStruct> type;
    private final EaseonFeatureCategory category;
    private final EaseonFeatureSubCategory subCategory;
    private final Supplier<FeatureStruct> defaultSupplier;
    public final int MinValue;
    public final int MaxValue;
    public final String ValueFormat;
    private static final LinkedHashMap<String, EaseonFeatureType> REGISTRY = new LinkedHashMap();

    private EaseonFeatureType(String id, String title, Class<? extends FeatureStruct> type, EaseonFeatureCategory category, EaseonFeatureSubCategory subCategory, Supplier<FeatureStruct> defaultSupplier, int sliderMinValue, int sliderMaxValue, String ValueFormat) {
        if (REGISTRY.containsKey(id)) {
            throw new IllegalArgumentException("[Easeon] FeatureType name '" + id + "' already registered!");
        }
        this.id = id;
        this.title = title;
        this.type = type;
        this.category = category;
        this.subCategory = subCategory;
        this.defaultSupplier = defaultSupplier;
        this.MinValue = sliderMinValue;
        this.MaxValue = sliderMaxValue;
        this.ValueFormat = ValueFormat;
    }

    public static void registerHotkey(String id, String name, EaseonFeatureCategory category, EaseonFeatureSubCategory subCategory, Supplier<HotkeyConfig> defaultSupplier) {
        REGISTRY.computeIfAbsent(id, k -> new EaseonFeatureType(id, name, HotkeyConfig.class, category, subCategory, ((Supplier)defaultSupplier)::get, 0, 0, null));
    }

    public static void registerToggle(String id, String name, EaseonFeatureCategory category, EaseonFeatureSubCategory subCategory, Supplier<ToggleConfig> defaultSupplier) {
        REGISTRY.computeIfAbsent(id, k -> new EaseonFeatureType(id, name, ToggleConfig.class, category, subCategory, ((Supplier)defaultSupplier)::get, 0, 0, null));
    }

    public static void registerSlider(String id, String name, EaseonFeatureCategory category, EaseonFeatureSubCategory subCategory, Supplier<SliderConfig> defaultSupplier, int sliderMinValue, int sliderMaxValue, String ValueFormat) {
        REGISTRY.computeIfAbsent(id, k -> new EaseonFeatureType(id, name, SliderConfig.class, category, subCategory, ((Supplier)defaultSupplier)::get, sliderMinValue, sliderMaxValue, ValueFormat));
    }

    public static EaseonFeatureType[] values() {
        return REGISTRY.values().toArray(new EaseonFeatureType[0]);
    }

    public static EaseonFeatureType valueOf(String id) {
        return REGISTRY.get(id);
    }

    public String getId() {
        return this.id;
    }

    public EaseonFeatureSubCategory getSubCategory() {
        return this.subCategory;
    }

    public class_2561 getSliderText(double value) {
        return class_2561.method_43469((String)this.ValueFormat, (Object[])new Object[]{value});
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)this.title);
    }

    public int getCategoryIndex() {
        EaseonFeatureCategory[] categories = EaseonFeatureCategory.values();
        for (int i = 0; i < categories.length; ++i) {
            if (!categories[i].equals(this.category)) continue;
            return i;
        }
        return -1;
    }

    public Class<? extends FeatureStruct> getStructClass() {
        return this.type;
    }

    public FeatureStruct createDefault() {
        if (this.defaultSupplier == null) {
            return null;
        }
        FeatureStruct fs = this.defaultSupplier.get();
        if (fs != null) {
            fs.applyDefaults();
        }
        return fs;
    }

    public boolean isChanged(FeatureStruct current) {
        JsonNode currentNode;
        if (current == null || this.defaultSupplier == null) {
            return false;
        }
        ObjectMapper mapper = new ObjectMapper();
        FeatureStruct def = this.defaultSupplier.get();
        if (def == null) {
            return false;
        }
        JsonNode defaultNode = mapper.valueToTree((Object)def);
        return !Objects.equals(defaultNode, currentNode = mapper.valueToTree((Object)current));
    }
}

