/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.cs.core.gui;

import com.easeon.cs.core.api.EaseonFeatureType;
import com.easeon.cs.core.config.EaseonConfig;
import com.easeon.cs.core.config.model.FeatureStruct;
import com.easeon.cs.core.config.model.HotkeyConfig;
import com.easeon.cs.core.config.model.SliderConfig;
import com.easeon.cs.core.config.model.ToggleConfig;
import com.easeon.cs.core.gui.common.GuiRenderable;
import com.easeon.cs.core.gui.section.HotkeySection;
import com.easeon.cs.core.gui.section.SliderSection;
import com.easeon.cs.core.gui.section.ToggleSection;
import com.easeon.cs.core.gui.views.ScrollView;
import com.easeon.cs.core.gui.views.SideView;
import com.easeon.cs.core.gui.views.TabSection;
import com.easeon.cs.core.gui.widget.EaseonSlider;
import com.easeon.cs.core.gui.widget.SectionHeader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class EaseonScreen
extends class_437 {
    public int tabIndex = 0;
    private TabSection tabSection;
    public ScrollView scrollView;
    public final List<GuiRenderable> widgets = new ArrayList<GuiRenderable>();
    private SideView sideSection;
    public HotkeySection activeCaptureSection = null;

    public EaseonScreen() {
        super((class_2561)class_2561.method_43471((String)EaseonConfig.modName));
    }

    public void method_25426() {
        this.method_25396().clear();
        this.sideSection = new SideView(this);
        this.widgets.clear();
        String prevPanel = null;
        for (EaseonFeatureType feature : EaseonFeatureType.values()) {
            Class<? extends FeatureStruct> cls;
            if (feature.getCategoryIndex() != this.tabIndex) continue;
            String subId = feature.getSubCategory().getId();
            String subTitle = feature.getSubCategory().getTitle();
            if (!Objects.equals(prevPanel, subId)) {
                prevPanel = subId;
                this.widgets.add(new SectionHeader(subTitle));
            }
            if (SliderConfig.class.isAssignableFrom(cls = feature.getStructClass())) {
                this.widgets.add(new SliderSection(this, feature));
                continue;
            }
            if (ToggleConfig.class.isAssignableFrom(cls)) {
                this.widgets.add(new ToggleSection(this, feature));
                continue;
            }
            if (!HotkeyConfig.class.isAssignableFrom(cls)) continue;
            this.widgets.add(new HotkeySection(this, feature));
        }
        this.scrollView = new ScrollView(this.widgets);
        this.tabSection = new TabSection(this);
    }

    public void refreshUI() {
        this.sideSection.reset.field_22763 = !EaseonConfig.allDefault();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -1072689136);
        this.sideSection.render(context, mouseX, mouseY, delta);
        this.tabSection.render(context, mouseX, mouseY, delta);
        context.method_25294(this.scrollView.x1, this.scrollView.y1 - 2, this.scrollView.x2, this.scrollView.y1 - 1, -2139062144);
        context.method_25294(this.scrollView.x1, this.scrollView.y1 - 1, this.scrollView.x2, this.scrollView.y1, -1073741824);
        context.method_25294(this.scrollView.x1, this.scrollView.y1, this.scrollView.x2, this.scrollView.y2, Integer.MIN_VALUE);
        context.method_25294(this.scrollView.x1, this.scrollView.y2, this.scrollView.x2, this.scrollView.y2 + 1, -1073741824);
        context.method_25294(this.scrollView.x1, this.scrollView.y2 + 1, this.scrollView.x2, this.scrollView.y2 + 2, -2139062144);
        context.method_44379(this.scrollView.x1, this.scrollView.y1, this.scrollView.x2, this.scrollView.y2);
        this.renderScissorWidgets(context, mouseX, mouseY, delta);
        this.renderScroll(context);
        context.method_44380();
        int titleX = this.field_22789 - 45 - 5;
        context.method_27534(this.field_22793, this.field_22785, titleX, 40, -1);
    }

    private void renderScissorWidgets(class_332 context, int mouseX, int mouseY, float delta) {
        int row = 0;
        for (GuiRenderable widget : this.widgets) {
            int baseY = 10 + row * 22 - (int)this.scrollView.scrollOffset + 20;
            widget.SetY(baseY);
            if (baseY + 20 >= this.scrollView.y1 && baseY <= this.scrollView.y2) {
                widget.render(context, mouseX, mouseY, delta);
            }
            ++row;
        }
    }

    private void renderScroll(class_332 context) {
        if (this.scrollView.isScrollbarHidden()) {
            return;
        }
        this.scrollView.updateScrollBarMetrics();
        context.method_25294(this.scrollView.trackX1, this.scrollView.y1, this.scrollView.x2, this.scrollView.y2, -16777216);
        context.method_25294(this.scrollView.trackX1, this.scrollView.scrollBarY, this.scrollView.x2, this.scrollView.scrollBarY + this.scrollView.scrollBarHeight, -2139062144);
        context.method_25294(this.scrollView.trackX1, this.scrollView.scrollBarY, this.scrollView.x2 - 1, this.scrollView.scrollBarY + this.scrollView.scrollBarHeight - 1, -2134851392);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        this.scrollView.scrollBy((float)(vertical * 20.0));
        return true;
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (this.tabSection != null && !this.tabSection.tabList.isEmpty()) {
            class_4185 first = this.tabSection.tabList.getFirst();
            int tabY1 = first.method_46427();
            int tabY2 = first.method_46427() + first.method_25364() + 2;
            int tabX1 = this.scrollView.x1;
            int tabX2 = this.scrollView.x2;
            if (mouseY >= (double)tabY1 && mouseY <= (double)tabY2 && mouseX >= (double)tabX1 && mouseX <= (double)tabX2) {
                for (class_4185 tab : this.tabSection.tabList) {
                    if (!tab.method_25402(click, doubled)) continue;
                    return true;
                }
                return true;
            }
        }
        if (mouseY > (double)this.scrollView.y2) {
            return true;
        }
        if (button == 0 && this.scrollView.isOverScrollBar(mouseX, mouseY)) {
            this.scrollView.beginDragging(mouseY);
            return true;
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        double mouseY = click.comp_4799();
        if (this.scrollView.isDragging) {
            float ratio = this.scrollView.getScrollRatioFromMouse(mouseY);
            this.scrollView.scrollToRatio(ratio);
            return true;
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25406(class_11909 click) {
        this.scrollView.endDragging();
        return super.method_25406(click);
    }

    public boolean method_25404(class_11908 keyInput) {
        int keyCode = keyInput.method_74228();
        int modifiers = keyInput.comp_4797();
        if (this.activeCaptureSection == null) {
            return super.method_25404(keyInput);
        }
        if (keyCode == 256) {
            this.activeCaptureSection.handleCapturedKey(0, 0);
            this.activeCaptureSection.refreshUI();
            this.activeCaptureSection = null;
            return true;
        }
        if (keyCode == 340 || keyCode == 344 || keyCode == 341 || keyCode == 345 || keyCode == 342 || keyCode == 346) {
            return super.method_25404(keyInput);
        }
        if (keyCode != -1) {
            int mod = 0;
            if ((modifiers & 1) != 0) {
                mod |= 1;
            }
            if ((modifiers & 2) != 0) {
                mod |= 2;
            }
            if ((modifiers & 4) != 0) {
                mod |= 4;
            }
            this.activeCaptureSection.handleCapturedKey(keyCode, mod);
            this.activeCaptureSection.refreshUI();
            this.activeCaptureSection = null;
            return true;
        }
        return true;
    }

    public <T extends class_4185> void registerChild(T widget) {
        super.method_37063(widget);
    }

    public <T extends EaseonSlider> void registerChild2(T widget) {
        super.method_37063(widget);
    }

    public boolean method_25421() {
        return true;
    }
}

