/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.cs.core.gui.section;

import com.easeon.cs.core.api.EaseonFeatureType;
import com.easeon.cs.core.config.EaseonConfig;
import com.easeon.cs.core.config.GuiConfig;
import com.easeon.cs.core.config.StringKey;
import com.easeon.cs.core.config.model.FeatureStruct;
import com.easeon.cs.core.config.model.HotkeyConfig;
import com.easeon.cs.core.gui.EaseonScreen;
import com.easeon.cs.core.gui.common.GuiRenderable;
import com.easeon.cs.core.gui.widget.EaseonButton;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class HotkeySection
implements GuiRenderable {
    private final EaseonScreen _screen;
    private final FeatureStruct _struct;
    private final EaseonFeatureType _type;
    private final HotkeyConfig _config;
    public final class_4185 hotkeyButton;
    public final class_4185 toggleButton;
    public final class_4185 resetButton;
    private int _y = 0;

    public HotkeySection(EaseonScreen screen, EaseonFeatureType type) {
        this._struct = EaseonConfig.configMap.get(type);
        this._config = (HotkeyConfig)this._struct;
        this._screen = screen;
        this._type = type;
        this.hotkeyButton = new EaseonButton(this.getHotkeyText(), GuiConfig.getHotkeyButtonX(), 80, btn -> {
            screen.activeCaptureSection = this;
            btn.method_25355(class_2561.method_30163((String)"..."));
        });
        this.toggleButton = new EaseonButton(this.getToggleButtonText(), GuiConfig.getToggleButtonX(), btn -> {
            this._config.Enabled = !this._config.Enabled;
            this.refreshUI();
        });
        this.resetButton = new EaseonButton(StringKey.BUTTON_RESET.asText(new Object[0]), GuiConfig.getResetButtonX(), btn -> {
            EaseonConfig.reset(this._type);
            this.refreshUI();
        });
        screen.registerChild(this.hotkeyButton);
        screen.registerChild(this.toggleButton);
        screen.registerChild(this.resetButton);
        this.refreshUI();
    }

    public void handleCapturedKey(int key, int mod) {
        this._config.Key = key;
        this._config.Mod = mod;
    }

    private class_2561 getHotkeyText() {
        Object keyName;
        int key = this._config.Key;
        int mod = this._config.Mod;
        if (key == 0) {
            return StringKey.BUTTON_HOTKEY_EMPTY.asText(new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        if ((mod & 1) != 0) {
            sb.append("Shift + ");
        }
        if ((mod & 2) != 0) {
            sb.append("Ctrl + ");
        }
        if ((mod & 4) != 0) {
            sb.append("Alt + ");
        }
        if ((keyName = GLFW.glfwGetKeyName((int)key, (int)0)) == null) {
            keyName = switch (key) {
                case 340 -> "Left Shift";
                case 344 -> "Right Shift";
                case 341 -> "Left Ctrl";
                case 345 -> "Right Ctrl";
                case 342 -> "Left Alt";
                case 346 -> "Right Alt";
                case 257 -> "Enter";
                case 258 -> "Tab";
                case 259 -> "Backspace";
                case 261 -> "Delete";
                case 265 -> "Up";
                case 264 -> "Down";
                case 263 -> "Left";
                case 262 -> "Right";
                case 290 -> "F1";
                case 291 -> "F2";
                case 292 -> "F3";
                case 293 -> "F4";
                case 294 -> "F5";
                case 295 -> "F6";
                case 296 -> "F7";
                case 297 -> "F8";
                case 298 -> "F9";
                case 299 -> "F10";
                case 300 -> "F11";
                case 301 -> "F12";
                default -> "Unknown(" + key + ")";
            };
        }
        sb.append(((String)keyName).toUpperCase());
        return class_2561.method_30163((String)sb.toString());
    }

    private class_2561 getToggleButtonText() {
        return this._config.Enabled ? StringKey.BUTTON_TOGGLE_ON.asText(new Object[0]) : StringKey.BUTTON_TOGGLE_OFF.asText(new Object[0]);
    }

    @Override
    public void refreshUI() {
        this.hotkeyButton.method_25355(this.getHotkeyText());
        this.hotkeyButton.field_22763 = this._config.Enabled;
        this.toggleButton.method_25355(this.getToggleButtonText());
        this.resetButton.field_22763 = this._type.isChanged(this._struct);
        this._screen.refreshUI();
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_327 tr = class_310.method_1551().field_1772;
        Objects.requireNonNull(tr);
        int fontH = 9;
        int rowH = this.toggleButton.method_25364();
        int textY = this._y + (rowH - fontH) / 2;
        context.method_51439(tr, this._type.getTitle(), 15, textY, -1, true);
        this.hotkeyButton.method_25394(context, mouseX, mouseY, delta);
        this.toggleButton.method_25394(context, mouseX, mouseY, delta);
        this.resetButton.method_25394(context, mouseX, mouseY, delta);
    }

    @Override
    public void SetY(int y) {
        this._y = y;
        this.hotkeyButton.method_46419(y);
        this.toggleButton.method_46419(y);
        this.resetButton.method_46419(y);
    }
}

