/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.cs.core.gui.section;

import com.easeon.cs.core.api.EaseonFeatureType;
import com.easeon.cs.core.config.EaseonConfig;
import com.easeon.cs.core.config.GuiConfig;
import com.easeon.cs.core.config.StringKey;
import com.easeon.cs.core.config.model.FeatureStruct;
import com.easeon.cs.core.config.model.ToggleConfig;
import com.easeon.cs.core.gui.EaseonScreen;
import com.easeon.cs.core.gui.common.GuiRenderable;
import com.easeon.cs.core.gui.widget.EaseonButton;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;

@Environment(value=EnvType.CLIENT)
public class ToggleSection
implements GuiRenderable {
    private final EaseonScreen _screen;
    private final FeatureStruct _struct;
    private final EaseonFeatureType _type;
    private final ToggleConfig _config;
    public final class_4185 toggleButton;
    public final class_4185 resetButton;
    private int _y = 0;

    public ToggleSection(EaseonScreen screen, EaseonFeatureType type) {
        this._struct = EaseonConfig.configMap.get(type);
        this._config = (ToggleConfig)this._struct;
        this._screen = screen;
        this._type = type;
        this.toggleButton = new EaseonButton(this.getToggleButtonText(), GuiConfig.getToggleButtonX(), btn -> {
            this._config.Enabled = !this._config.Enabled;
            this.refreshUI();
        });
        this.resetButton = new EaseonButton(StringKey.BUTTON_RESET.asText(new Object[0]), GuiConfig.getResetButtonX(), btn -> {
            EaseonConfig.reset(this._type);
            this.refreshUI();
        });
        screen.registerChild(this.toggleButton);
        screen.registerChild(this.resetButton);
        this.refreshUI();
    }

    private class_2561 getToggleButtonText() {
        return this._config.Enabled ? StringKey.BUTTON_TOGGLE_ON.asText(new Object[0]) : StringKey.BUTTON_TOGGLE_OFF.asText(new Object[0]);
    }

    @Override
    public void refreshUI() {
        this.toggleButton.method_25355(this.getToggleButtonText());
        this.resetButton.field_22763 = this._type.isChanged(this._struct);
        this._screen.refreshUI();
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_327 tr = class_310.method_1551().field_1772;
        Objects.requireNonNull(tr);
        int fontH = 9;
        int rowH = this.toggleButton.method_25364();
        int textY = this._y + (rowH - fontH) / 2;
        context.method_51439(tr, this._type.getTitle(), 15, textY, -1, true);
        this.toggleButton.method_25394(context, mouseX, mouseY, delta);
        this.resetButton.method_25394(context, mouseX, mouseY, delta);
    }

    @Override
    public void SetY(int y) {
        this._y = y;
        this.toggleButton.method_46419(y);
        this.resetButton.method_46419(y);
    }
}

