/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.modscommand.configuration;

import io.leangen.geantyref.TypeToken;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.loader.ConfigurationLoader;

@DefaultQualifier(value=NonNull.class)
public final class ConfigHolder<C> {
    private final TypeToken<C> configType;
    private final Path configFile;
    private final ConfigurationLoader<?> configLoader;
    private volatile @Nullable C config;

    private ConfigHolder(Path file, TypeToken<C> configType) {
        this.configType = configType;
        this.configFile = file;
        this.configLoader = ConfigHolder.createLoader(this.configFile);
    }

    public C config() {
        @Nullable C config = this.config;
        if (config == null) {
            throw new IllegalStateException("Config is not loaded (null)");
        }
        return config;
    }

    public @Nullable C configIfLoaded() {
        return this.config;
    }

    public synchronized void load() throws IOException {
        @Nullable Object loaded = null;
        @Nullable IOException fail = null;
        try {
            if (!Files.exists(this.configFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
            }
            ConfigurationNode load = this.configLoader.load();
            loaded = load.get(this.configType);
        }
        catch (IOException ex) {
            fail = ex;
        }
        if (loaded == null) {
            if (fail == null) {
                fail = new IOException("Failed to coerce loaded config node to correct type %s".formatted(this.configType.getType().getTypeName()));
            }
            throw new IOException("Failed to load config file %s".formatted(this.configFile), fail);
        }
        this.config = loaded;
        try {
            this.configLoader.save(this.configLoader.createNode(node -> node.set(this.config)));
        }
        catch (IOException ex) {
            throw new IOException("Failed to write back loaded config file %s".formatted(this.configFile), ex);
        }
    }

    private static HoconConfigurationLoader createLoader(Path file) {
        return ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(file)).build();
    }

    public static <C> ConfigHolder<C> create(Path file, TypeToken<C> configType) {
        return new ConfigHolder<C>(file, configType);
    }

    public static <C> ConfigHolder<C> create(Path file, Class<C> configType) {
        return new ConfigHolder<C>(file, TypeToken.get(configType));
    }

    public static <C> ConfigHolder<C> create(ModContainer modContainer, TypeToken<C> configType) {
        Path file = FabricLoader.getInstance().getConfigDir().resolve(modContainer.getMetadata().getId() + ".conf");
        return ConfigHolder.create(file, configType);
    }

    public static <C> ConfigHolder<C> create(ModContainer modContainer, Class<C> configType) {
        return ConfigHolder.create(modContainer, TypeToken.get(configType));
    }
}

