/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.modscommand.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.kyori.examination.Examinable;
import net.kyori.examination.string.StringExaminer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.modscommand.model.ModDescription;

@DefaultQualifier(value=NonNull.class)
public abstract class AbstractModDescription
implements ModDescription {
    private final List<ModDescription> children = new ArrayList<ModDescription>();
    private @Nullable ModDescription parent = null;

    protected AbstractModDescription(List<ModDescription> children) {
        for (ModDescription child : children) {
            this.addChild(child);
        }
    }

    public void addChild(ModDescription newChild) {
        if (!(newChild instanceof AbstractModDescription)) {
            throw new IllegalArgumentException(String.format("Cannot add non-AbstractModDescription as a child. Attempted to add %s '%s'.", newChild.getClass().getName(), newChild));
        }
        AbstractModDescription newChildAbs = (AbstractModDescription)newChild;
        newChildAbs.parent = this;
        this.children.add(newChild);
        this.children.sort(Comparator.comparing(ModDescription::modId));
    }

    @Override
    public @Nullable ModDescription parent() {
        return this.parent;
    }

    @Override
    public List<ModDescription> children() {
        return Collections.unmodifiableList(this.children);
    }

    public String toString() {
        return (String)StringExaminer.simpleEscaping().examine((Examinable)this);
    }
}

