/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.modscommand.model;

import io.leangen.geantyref.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.modscommand.model.Environment;
import xyz.jpenilla.modscommand.model.FabricModMetadataModDescription;
import xyz.jpenilla.modscommand.model.ModDescriptionImpl;

@DefaultQualifier(value=NonNull.class)
public interface ModDescription
extends Examinable {
    public @Nullable ModDescription parent();

    public List<ModDescription> children();

    public String modId();

    public String name();

    public String version();

    public String type();

    public String description();

    public Collection<String> authors();

    public Collection<String> contributors();

    public Collection<String> licenses();

    public Map<String, String> contact();

    public Environment environment();

    default public boolean hasAttribute(TypeToken<?> type) {
        return false;
    }

    default public boolean hasAttribute(Class<?> type) {
        return this.hasAttribute(TypeToken.get(type));
    }

    default public <A> A attribute(TypeToken<A> type) {
        throw new IllegalArgumentException();
    }

    default public <A> A attribute(Class<A> type) {
        return this.attribute(TypeToken.get(type));
    }

    default public Stream<ModDescription> parentStream() {
        @Nullable ModDescription parent = this.parent();
        if (parent == null) {
            return Stream.empty();
        }
        return parent.selfAndParents();
    }

    default public Stream<ModDescription> selfAndParents() {
        return Stream.concat(Stream.of(this), this.parentStream());
    }

    default public Stream<ModDescription> childrenStream() {
        return this.children().stream().flatMap(ModDescription::selfAndChildren);
    }

    default public Stream<ModDescription> selfAndChildren() {
        return Stream.concat(Stream.of(this), this.childrenStream());
    }

    default public Stream<ExaminableProperty> examinableProperties() {
        @Nullable ModDescription parent = this.parent();
        return Stream.of(ExaminableProperty.of((String)"modId", (String)this.modId()), ExaminableProperty.of((String)"name", (String)this.name()), ExaminableProperty.of((String)"version", (String)this.version()), ExaminableProperty.of((String)"type", (String)this.type()), ExaminableProperty.of((String)"description", (String)this.description()), ExaminableProperty.of((String)"authors", this.authors()), ExaminableProperty.of((String)"contributors", this.contributors()), ExaminableProperty.of((String)"licenses", this.licenses()), ExaminableProperty.of((String)"contact", this.contact()), ExaminableProperty.of((String)"environment", (Object)((Object)this.environment())), ExaminableProperty.of((String)"parent", (String)(parent == null ? null : parent.modId())), ExaminableProperty.of((String)"children", this.children()));
    }

    public static ModDescription fromFabric(ModMetadata fabric) {
        return new FabricModMetadataModDescription(fabric, new ModDescription[0]);
    }

    public static ModDescription create(List<ModDescription> children, String modId, String name, String version, String type, String description, Collection<String> authors, Collection<String> contributors, Collection<String> licenses, Map<String, String> contact, Environment environment) {
        return new ModDescriptionImpl(children, modId, name, version, type, description, authors, contributors, licenses, contact, environment);
    }
}

