/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.modscommand;

import java.io.IOException;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.fabric.FabricServerCommandManager;
import org.incendo.cloud.permission.Permission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.jpenilla.modscommand.command.Commander;
import xyz.jpenilla.modscommand.command.Commands;
import xyz.jpenilla.modscommand.command.commands.DumpModsCommand;
import xyz.jpenilla.modscommand.command.commands.ModsCommand;
import xyz.jpenilla.modscommand.configuration.Config;
import xyz.jpenilla.modscommand.configuration.ConfigHolder;
import xyz.jpenilla.modscommand.model.Mods;

@DefaultQualifier(value=NonNull.class)
public final class ModsCommandModInitializer
implements ModInitializer {
    private static @MonotonicNonNull ModsCommandModInitializer instance;
    public static final Logger LOGGER;
    private final ConfigHolder<Config> configHolder = ConfigHolder.create((ModContainer)FabricLoader.getInstance().getModContainer("mods-command").orElseThrow(), Config.class);

    public void onInitialize() {
        instance = this;
        this.loadConfig();
        Mods mods = Mods.mods();
        LOGGER.info("Mods Command detected {} loaded mods ({} top-level).", (Object)mods.totalModCount(), (Object)mods.topLevelModCount());
        FabricServerCommandManager manager = new FabricServerCommandManager(ExecutionCoordinator.simpleCoordinator(), SenderMapper.create(Commander.ServerCommander::new, commander -> ((Commander.ServerCommander)commander).source()));
        Commands.configureCommandManager(manager);
        ModsCommand modsCommand = new ModsCommand("mods", Permission.of((String)"modscommand.mods"));
        modsCommand.register((CommandManager<Commander>)manager);
        DumpModsCommand dumpModsCommand = new DumpModsCommand("dumpmods", Permission.of((String)"modscommand.dumpmods"));
        dumpModsCommand.register((CommandManager<Commander>)manager);
    }

    private void loadConfig() {
        try {
            this.configHolder.load();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load Mods Command config", ex);
        }
    }

    public Config config() {
        return this.configHolder.config();
    }

    public static ModsCommandModInitializer instance() {
        if (instance == null) {
            throw new IllegalStateException("Mods Command has not yet been initialized!");
        }
        return instance;
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"Mods Command");
    }
}

