/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.modscommand.command.commands;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.permission.Permission;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import xyz.jpenilla.modscommand.command.Commander;
import xyz.jpenilla.modscommand.command.RegistrableCommand;
import xyz.jpenilla.modscommand.model.ModDescription;
import xyz.jpenilla.modscommand.model.Mods;
import xyz.jpenilla.modscommand.util.Colors;

@DefaultQualifier(value=NonNull.class)
public final class DumpModsCommand
implements RegistrableCommand {
    private final String label;
    private final @Nullable Permission permission;
    private final Path dumpFile;

    public DumpModsCommand(String primaryAlias, @Nullable Permission permission) {
        this.label = primaryAlias;
        this.permission = permission;
        this.dumpFile = FabricLoader.getInstance().getGameDir().resolve("installed-mods.yml");
    }

    @Override
    public void register(CommandManager<Commander> manager) {
        Command.Builder builder = manager.commandBuilder(this.label, new String[0]);
        if (this.permission == null) {
            manager.command(builder.handler(this::executeDumpModList));
        } else {
            manager.command(builder.permission(this.permission).handler(this::executeDumpModList));
        }
    }

    private void executeDumpModList(CommandContext<Commander> ctx) {
        String dump;
        try {
            dump = DumpModsCommand.createDump();
            Files.writeString(this.dumpFile, (CharSequence)dump, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create mod list dump.", ex);
        }
        TextComponent.Builder message = (TextComponent.Builder)((TextComponent.Builder)Component.text().content("Saved list of installed mods to ").append((Component)Component.text(builder -> {
            builder.content(this.dumpFile.getFileName().toString()).color(Colors.PINK);
            if (ctx.sender() instanceof Commander.ClientCommander) {
                ((TextComponent.Builder)builder.clickEvent(ClickEvent.openFile((String)this.dumpFile.toAbsolutePath().toString()))).hoverEvent((HoverEventSource)Component.text((String)"Click to open file!", (TextColor)Colors.EMERALD));
            }
        }))).append((Component)Component.text((String)" in the game directory."));
        ((Commander)ctx.sender()).sendMessage((ComponentLike)message);
        TextComponent.Builder copyMessage = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Click here to copy it's contents to the clipboard.").color(Colors.PINK)).clickEvent(ClickEvent.copyToClipboard((String)dump))).hoverEvent((HoverEventSource)Component.text((String)"Click to copy to clipboard!", (TextColor)Colors.EMERALD));
        ((Commander)ctx.sender()).sendMessage((ComponentLike)copyMessage);
    }

    private static String createDump() throws ConfigurateException {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().sink(() -> bufferedWriter)).nodeStyle(NodeStyle.BLOCK).build();
        ConfigurationNode root = loader.createNode();
        FabricLoader fabricLoader = FabricLoader.getInstance();
        root.node(new Object[]{"environment-type"}).set((Object)fabricLoader.getEnvironmentType());
        root.node(new Object[]{"development-environment"}).set((Object)fabricLoader.isDevelopmentEnvironment());
        root.node(new Object[]{"launch-arguments"}).set((Object)fabricLoader.getLaunchArguments(true));
        ConfigurationNode os = root.node(new Object[]{"operating-system"});
        os.node(new Object[]{"arch"}).set((Object)System.getProperty("os.arch"));
        os.node(new Object[]{"name"}).set((Object)System.getProperty("os.name"));
        os.node(new Object[]{"version"}).set((Object)System.getProperty("os.version"));
        ConfigurationNode java = root.node(new Object[]{"java"});
        java.node(new Object[]{"vendor"}).set((Object)System.getProperty("java.vendor"));
        java.node(new Object[]{"vendor-url"}).set((Object)System.getProperty("java.vendor.url"));
        java.node(new Object[]{"version"}).set((Object)System.getProperty("java.version"));
        ConfigurationNode modsNode = root.node(new Object[]{"mods"});
        for (ModDescription mod : Mods.mods().topLevelMods()) {
            DumpModsCommand.serializeModDescriptionToNode(modsNode, mod);
        }
        loader.save(root);
        return stringWriter.toString();
    }

    private static void serializeModDescriptionToNode(ConfigurationNode node, ModDescription mod) throws SerializationException {
        ConfigurationNode modNode = node.appendListNode();
        modNode.node(new Object[]{"mod-id"}).set((Object)mod.modId());
        modNode.node(new Object[]{"name"}).set((Object)mod.name());
        modNode.node(new Object[]{"version"}).set((Object)mod.version());
        if (!mod.authors().isEmpty()) {
            modNode.node(new Object[]{"authors"}).set((Object)String.join((CharSequence)", ", mod.authors()));
        }
        for (ModDescription child : mod.children()) {
            DumpModsCommand.serializeModDescriptionToNode(modNode.node(new Object[]{"children"}), child);
        }
    }
}

