/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.modscommand.command.commands;

import com.terraformersmc.modmenu.ModMenu;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.component.DefaultValue;
import org.incendo.cloud.component.TypedCommandComponent;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.key.CloudKey;
import org.incendo.cloud.parser.standard.IntegerParser;
import org.incendo.cloud.parser.standard.StringParser;
import org.incendo.cloud.permission.Permission;
import xyz.jpenilla.modscommand.command.Commander;
import xyz.jpenilla.modscommand.command.RegistrableCommand;
import xyz.jpenilla.modscommand.command.argument.parser.ModDescriptionParser;
import xyz.jpenilla.modscommand.model.Environment;
import xyz.jpenilla.modscommand.model.ModDescription;
import xyz.jpenilla.modscommand.model.Mods;
import xyz.jpenilla.modscommand.util.BiIntFunction;
import xyz.jpenilla.modscommand.util.Colors;
import xyz.jpenilla.modscommand.util.Pagination;

@DefaultQualifier(value=NonNull.class)
public final class ModsCommand
implements RegistrableCommand {
    private static final CloudKey<ModDescription> MOD_ARGUMENT_KEY = CloudKey.cloudKey((String)"mod_id", ModDescription.class);
    private static final CloudKey<Integer> PAGE_ARGUMENT_KEY = CloudKey.cloudKey((String)"page_number", Integer.class);
    private static final CloudKey<String> QUERY_ARGUMENT_KEY = CloudKey.cloudKey((String)"query", String.class);
    private static final Pattern URL_PATTERN = Pattern.compile("(?:(https?)://)?([-\\w_.]+\\.\\w{2,})(/\\S*)?");
    private static final Component GRAY_SEPARATOR = Component.text((char)':', (TextColor)NamedTextColor.GRAY);
    private static final Component DASH = Component.text((String)" - ", (TextColor)Colors.MIDNIGHT_BLUE);
    private final String label;
    private final @Nullable Permission permission;

    public ModsCommand(String primaryAlias, @Nullable Permission permission) {
        this.label = primaryAlias;
        this.permission = permission;
    }

    @Override
    public void register(CommandManager<Commander> manager) {
        Command.Builder base = manager.commandBuilder(this.label, new String[0]);
        Command.Builder mods = this.permission != null ? base.permission(this.permission) : base;
        manager.command(mods.handler(this::executeListMods));
        manager.command(mods.literal("page", new String[0]).argument(ModsCommand.pageArgument()).handler(this::executeListMods));
        Command.Builder info = mods.literal("info", new String[0]).required(MOD_ARGUMENT_KEY, ModDescriptionParser.modDescriptionParser());
        manager.command(info.handler(this::executeModInfo));
        manager.command(info.literal("children", new String[0]).argument(ModsCommand.pageArgument()).handler(this::executeListChildren));
        manager.command(mods.literal("search", new String[0]).required(QUERY_ARGUMENT_KEY, StringParser.greedyStringParser()).handler(this::executeSearch));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && FabricLoader.getInstance().isModLoaded("modmenu")) {
            manager.command(mods.literal("config", new String[0]).required(MOD_ARGUMENT_KEY, ModDescriptionParser.modDescriptionParser()).handler(ctx -> {
                ModDescription mod = (ModDescription)ctx.get(MOD_ARGUMENT_KEY);
                class_310 client = class_310.method_1551();
                @Nullable class_437 configScreen = ModMenu.getConfigScreen((String)mod.modId(), (class_437)client.field_1755);
                if (configScreen == null) {
                    ((Commander)ctx.sender()).sendMessage((Component)Component.textOfChildren((ComponentLike[])new ComponentLike[]{ModsCommand.coloredBoldModName(mod), Component.text((String)" does not have a config screen!", (TextColor)Colors.MUSTARD)}));
                    return;
                }
                client.execute(() -> client.method_1507(configScreen));
            }));
        }
    }

    private static TypedCommandComponent<Commander, Integer> pageArgument() {
        return TypedCommandComponent.builder().parser(IntegerParser.integerParser((int)1)).name(PAGE_ARGUMENT_KEY.name()).optional().defaultValue(DefaultValue.constant((Object)1)).build();
    }

    private void executeListMods(CommandContext<Commander> ctx) {
        int page = ctx.optional(PAGE_ARGUMENT_KEY).orElse(1);
        Pagination<ModDescription> pagination = Pagination.builder().header((currentPage, pages) -> Component.textOfChildren((ComponentLike[])new ComponentLike[]{Component.text((String)"Loaded Mods", (TextColor)Colors.PURPLE, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}), Component.text((String)String.format(" (%s total, %s top-level)", Mods.mods().totalModCount(), Mods.mods().topLevelModCount()), (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC})})).footer(this.footerRenderer(p -> String.format("/%s page %d", this.label, p))).pageOutOfRange(ModsCommand::pageOutOfRange).item((item, lastOfPage) -> Component.textOfChildren((ComponentLike[])new ComponentLike[]{DASH, this.shortModDescription((ModDescription)item)})).build();
        pagination.render(Mods.mods().topLevelMods(), page, 8).forEach(arg_0 -> ((Commander)((Commander)ctx.sender())).sendMessage(arg_0));
    }

    private void executeListChildren(CommandContext<Commander> ctx) {
        ModDescription mod = (ModDescription)ctx.get(MOD_ARGUMENT_KEY);
        int page = (Integer)ctx.get(PAGE_ARGUMENT_KEY);
        if (mod.children().isEmpty()) {
            TextComponent.Builder message = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(Colors.MUSTARD)).content("Mod ").append(((TextComponent.Builder)Component.text().append((Component)ModsCommand.coloredBoldModName(mod))).apply(this.modClickAndHover(mod)))).append((Component)Component.text((String)" does not have any child mods!"));
            ((Commander)ctx.sender()).sendMessage((ComponentLike)message);
            return;
        }
        Pagination<ModDescription> pagination = Pagination.builder().header((currentPage, pages) -> ((TextComponent.Builder)((TextComponent.Builder)Component.text().color(Colors.MUSTARD)).append((Component)ModsCommand.coloredBoldModName(mod))).append((Component)Component.text((String)" child mods"))).footer(this.footerRenderer(p -> String.format("/%s info %s children %s", this.label, mod.modId(), p))).pageOutOfRange(ModsCommand::pageOutOfRange).item((item, lastOfPage) -> Component.textOfChildren((ComponentLike[])new ComponentLike[]{DASH, this.shortModDescription((ModDescription)item)})).build();
        pagination.render(mod.children(), page, 8).forEach(arg_0 -> ((Commander)((Commander)ctx.sender())).sendMessage(arg_0));
    }

    private void executeSearch(CommandContext<Commander> ctx) {
        String rawQuery = ctx.optional(QUERY_ARGUMENT_KEY).orElse("").toLowerCase(Locale.ENGLISH).trim();
        String[] split = rawQuery.split(" ");
        int page = 1;
        String tempQuery = rawQuery;
        if (split.length > 1) {
            try {
                String pageText = split[split.length - 1];
                page = Integer.parseInt(pageText);
                tempQuery = rawQuery.substring(0, Math.max(rawQuery.lastIndexOf(pageText) - 1, 0));
            }
            catch (NumberFormatException ex) {
                page = 1;
                tempQuery = rawQuery;
            }
        }
        String query = tempQuery;
        List<ModDescription> results = Mods.mods().allMods().filter(ModsCommand.matchesQuery(query)).flatMap(match -> Stream.concat(match.parentStream(), match.selfAndChildren())).distinct().sorted(Comparator.comparing(ModDescription::modId)).toList();
        if (results.isEmpty()) {
            ((Commander)ctx.sender()).sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(Colors.MUSTARD)).content("No results for query '").append((Component)Component.text((String)query, (TextColor)Colors.PURPLE))).append((Component)Component.text((String)"'.")));
            return;
        }
        Pagination<ModDescription> pagination = Pagination.builder().header((currentPage, pages) -> Component.textOfChildren((ComponentLike[])new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)Component.text().decorate(TextDecoration.BOLD)).append((Component)Component.text((int)results.size(), (TextColor)Colors.PINK))).append((Component)Component.text((String)" results for query", (TextColor)Colors.PURPLE)), GRAY_SEPARATOR, Component.space(), Component.text((String)query, (TextColor)Colors.MUSTARD)})).footer(this.footerRenderer(p -> String.format("/%s search %s %d", this.label, query, p))).pageOutOfRange(ModsCommand::pageOutOfRange).item((item, lastOfPage) -> Component.textOfChildren((ComponentLike[])new ComponentLike[]{DASH, this.shortModDescription((ModDescription)item)})).build();
        pagination.render(results, page, 8).forEach(arg_0 -> ((Commander)((Commander)ctx.sender())).sendMessage(arg_0));
    }

    private static Predicate<ModDescription> matchesQuery(String query) {
        String queryLower = query.toLowerCase(Locale.ENGLISH);
        return mod -> mod.modId().toLowerCase(Locale.ENGLISH).contains(queryLower) || mod.name().toLowerCase(Locale.ENGLISH).contains(queryLower) || "clientsided client-sided client sided".contains(queryLower) && mod.environment() == Environment.CLIENT || "serversided server-sided server sided".contains(queryLower) && mod.environment() == Environment.SERVER || mod.authors().stream().anyMatch(author -> author.toLowerCase(Locale.ENGLISH).contains(queryLower));
    }

    private BiIntFunction<ComponentLike> footerRenderer(IntFunction<String> commandFunction) {
        return (currentPage, pages) -> {
            if (pages == 1) {
                return Component.empty();
            }
            TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(Colors.MUSTARD)).content("Page ").append((Component)Component.text((int)currentPage, (TextColor)Colors.PURPLE))).append((Component)Component.text((char)'/'))).append((Component)Component.text((int)pages, (TextColor)Colors.PURPLE));
            if (currentPage > 1) {
                ((TextComponent.Builder)builder.append((Component)Component.space())).append(ModsCommand.previousPageButton(currentPage, commandFunction));
            }
            if (currentPage < pages) {
                ((TextComponent.Builder)builder.append((Component)Component.space())).append(ModsCommand.nextPageButton(currentPage, commandFunction));
            }
            return builder;
        };
    }

    private static Component previousPageButton(int currentPage, IntFunction<String> commandFunction) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u2190").color(Colors.BRIGHT_BLUE)).clickEvent(ClickEvent.runCommand((String)commandFunction.apply(currentPage - 1)))).hoverEvent((HoverEventSource)Component.text((String)"Click for previous page.", (TextColor)Colors.EMERALD))).build();
    }

    private static Component nextPageButton(int currentPage, IntFunction<String> commandFunction) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u2192").color(Colors.BRIGHT_BLUE)).clickEvent(ClickEvent.runCommand((String)commandFunction.apply(currentPage + 1)))).hoverEvent((HoverEventSource)Component.text((String)"Click for next page.", (TextColor)Colors.EMERALD))).build();
    }

    private static Component pageOutOfRange(int currentPage, int pages) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(Colors.MUSTARD)).content("Page ").append((Component)Component.text((int)currentPage, (TextColor)Colors.PURPLE))).append((Component)Component.text((String)" is out of range"))).append((Component)Component.text((char)'!'))).append((Component)Component.text((String)" There are only "))).append((Component)Component.text((int)pages, (TextColor)Colors.PURPLE))).append((Component)Component.text((String)" pages of results."))).build();
    }

    private void executeModInfo(CommandContext<Commander> ctx) {
        ModDescription parent;
        ModDescription mod = (ModDescription)ctx.get(MOD_ARGUMENT_KEY);
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)ModsCommand.coloredBoldModName(mod))).color(Colors.MUSTARD)).append((Component)Component.newline())).append((Component)Component.space())).append(ModsCommand.labelled("mod id", (ComponentLike)Component.text((String)mod.modId())));
        if (!mod.version().isEmpty()) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.space())).append(ModsCommand.labelled("version", (ComponentLike)Component.text((String)mod.version())));
        }
        if (!mod.description().isEmpty()) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.space())).append(ModsCommand.labelled("description", (ComponentLike)Component.text((String)mod.description())));
        }
        if (!mod.authors().isEmpty()) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.space())).append(ModsCommand.labelled("authors", (ComponentLike)mod.authors().stream().map(Component::text).collect(Component.toComponent((Component)Component.text((String)", ", (TextColor)NamedTextColor.GRAY)))));
        }
        if (!mod.contributors().isEmpty()) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.space())).append(ModsCommand.labelled("contributors", (ComponentLike)mod.contributors().stream().map(Component::text).collect(Component.toComponent((Component)Component.text((String)", ", (TextColor)NamedTextColor.GRAY)))));
        }
        if (!mod.licenses().isEmpty()) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.space())).append(ModsCommand.labelled("license", (ComponentLike)mod.licenses().stream().map(Component::text).collect(Component.toComponent((Component)Component.text((String)", ", (TextColor)NamedTextColor.GRAY)))));
        }
        ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.space())).append(ModsCommand.labelled("type", (ComponentLike)Component.text((String)mod.type())));
        if (mod.environment() != Environment.UNIVERSAL) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.space())).append(ModsCommand.labelled("environment", (ComponentLike)mod.environment().display()));
        }
        if ((parent = mod.parent()) != null) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.space())).append(ModsCommand.labelled("parent mod", (ComponentLike)Component.text().content(parent.modId()).apply(this.modClickAndHover(parent))));
        }
        if (!mod.children().isEmpty()) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.space())).append(ModsCommand.labelled("child mods", (ComponentLike)mod.children().stream().limit(5L).map(this::modIdWithClickAndHover).collect(Component.toComponent((Component)Component.text((String)", ", (TextColor)NamedTextColor.GRAY)))));
            if (mod.children().size() > 5) {
                builder.append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).decorate(TextDecoration.ITALIC)).content(", and " + (mod.children().size() - 5) + " more...").hoverEvent((HoverEventSource)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(Colors.EMERALD)).content("Click to see all of ").append((Component)ModsCommand.coloredBoldModName(mod))).append((Component)Component.text((String)"'s child mods."))).build())).clickEvent(ClickEvent.runCommand((String)String.format("/%s info %s children", this.label, mod.modId()))));
            }
        }
        if (!mod.contact().isEmpty()) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.space())).append(ModsCommand.labelled("contact", (ComponentLike)Component.empty()));
            mod.contact().forEach((key, value) -> {
                builder.append((Component)Component.newline());
                TextComponent.Builder info = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.space())).append(DASH)).append(ModsCommand.labelled(key, (ComponentLike)ModsCommand.openUrlOrCopyToClipboard(value)));
                builder.append((ComponentBuilder)info);
            });
        }
        ((Commander)ctx.sender()).sendMessage((ComponentLike)builder);
    }

    private static Component labelled(String label, ComponentLike value) {
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)label, (TextColor)Colors.BLUE))).append(GRAY_SEPARATOR);
        if (value != Component.empty()) {
            ((TextComponent.Builder)builder.append((Component)Component.space())).append(value);
        }
        return builder.build();
    }

    private static Component openUrlOrCopyToClipboard(String value) {
        TextComponent.Builder builder = (TextComponent.Builder)Component.text().content(value).color(Colors.BRIGHT_BLUE);
        Matcher matcher = URL_PATTERN.matcher(value);
        if (matcher.find() && matcher.group().equals(value)) {
            builder.hoverEvent((HoverEventSource)Component.text((String)"Click to open url!", (TextColor)Colors.EMERALD));
            builder.clickEvent(ClickEvent.openUrl((String)value));
            builder.decorate(TextDecoration.UNDERLINED);
        } else {
            builder.hoverEvent((HoverEventSource)Component.text((String)"Click to copy to clipboard!", (TextColor)Colors.EMERALD));
            builder.clickEvent(ClickEvent.copyToClipboard((String)value));
        }
        return builder.build();
    }

    private Component shortModDescription(ModDescription mod) {
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().apply(this.modClickAndHover(mod))).append((Component)Component.text((String)mod.name(), (TextColor)Colors.BLUE))).append((Component)Component.text((String)String.format(" (%s)", mod.modId()), (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
        if (!mod.version().isEmpty()) {
            builder.append((Component)Component.text((String)String.format(" v%s", mod.version()), (TextColor)Colors.EMERALD));
        }
        if (!mod.children().isEmpty()) {
            String mods = mod.children().size() == 1 ? "mod" : "mods";
            builder.append((Component)Component.text((String)String.format(" (%d child %s)", mod.childrenStream().count(), mods), (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
        }
        return builder.build();
    }

    private Component modIdWithClickAndHover(ModDescription mod) {
        return ((TextComponent.Builder)Component.text().content(mod.modId()).apply(this.modClickAndHover(mod))).build();
    }

    private Consumer<? super ComponentBuilder<?, ?>> modClickAndHover(ModDescription mod) {
        return builder -> builder.clickEvent(this.modInfo(mod)).hoverEvent((HoverEventSource)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(Colors.EMERALD)).content("Click to see more about ").append((Component)ModsCommand.coloredBoldModName(mod))).append((Component)Component.text((char)'!'))).build());
    }

    private static TextComponent coloredBoldModName(ModDescription mod) {
        return Component.text((String)mod.name(), (TextColor)Colors.PURPLE, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
    }

    private ClickEvent modInfo(ModDescription description) {
        return ClickEvent.runCommand((String)String.format("/%s info %s", this.label, description.modId()));
    }
}

