/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.modscommand.model;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.kyori.examination.ExaminableProperty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.modscommand.model.AbstractModDescription;
import xyz.jpenilla.modscommand.model.Environment;
import xyz.jpenilla.modscommand.model.ModDescription;

@DefaultQualifier(value=NonNull.class)
final class FabricModMetadataModDescription
extends AbstractModDescription {
    private final ModMetadata metadata;

    FabricModMetadataModDescription(ModMetadata metadata, ModDescription ... children) {
        super(Arrays.asList(children));
        this.metadata = metadata;
    }

    @Override
    public String modId() {
        return this.metadata.getId();
    }

    @Override
    public String name() {
        return this.metadata.getName();
    }

    @Override
    public String version() {
        return this.metadata.getVersion().getFriendlyString();
    }

    @Override
    public String type() {
        return this.metadata.getType();
    }

    @Override
    public String description() {
        return this.metadata.getDescription();
    }

    @Override
    public Collection<String> authors() {
        return this.metadata.getAuthors().stream().map(Person::getName).toList();
    }

    @Override
    public Collection<String> contributors() {
        return this.metadata.getContributors().stream().map(Person::getName).toList();
    }

    @Override
    public Collection<String> licenses() {
        return this.metadata.getLicense();
    }

    @Override
    public Map<String, String> contact() {
        return this.metadata.getContact().asMap();
    }

    @Override
    public Environment environment() {
        return FabricModMetadataModDescription.fromFabric(this.metadata.getEnvironment());
    }

    @Override
    public boolean hasAttribute(TypeToken<?> type) {
        if (GenericTypeReflector.erase((Type)type.getType()).equals(ModMetadata.class)) {
            return true;
        }
        return super.hasAttribute(type);
    }

    @Override
    public <A> A attribute(TypeToken<A> type) {
        if (GenericTypeReflector.erase((Type)type.getType()).equals(ModMetadata.class)) {
            return (A)this.metadata;
        }
        return super.attribute(type);
    }

    @Override
    public Stream<ExaminableProperty> examinableProperties() {
        return Stream.concat(super.examinableProperties(), Stream.of(ExaminableProperty.of((String)"metadata", (Object)this.metadata)));
    }

    private static Environment fromFabric(ModEnvironment modEnvironment) {
        return switch (modEnvironment) {
            default -> throw new MatchException(null, null);
            case ModEnvironment.CLIENT -> Environment.CLIENT;
            case ModEnvironment.SERVER -> Environment.SERVER;
            case ModEnvironment.UNIVERSAL -> Environment.UNIVERSAL;
        };
    }
}

