/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.modscommand.model;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.modscommand.ModsCommandModInitializer;
import xyz.jpenilla.modscommand.model.AbstractModDescription;
import xyz.jpenilla.modscommand.model.Environment;
import xyz.jpenilla.modscommand.model.ModDescription;

@DefaultQualifier(value=NonNull.class)
public final class Mods {
    private static final String QSL_MOD_ID = "qsl";
    private static final String LEGACY_FABRIC_API_MOD_ID = "fabric";
    private static final String FABRIC_API_MOD_ID = "fabric-api";
    private static final String QUILTED_FABRIC_API_MOD_ID = "quilted_fabric_api";
    private static final String FABRIC_API_MODULE_MARKER = "fabric-api:module-lifecycle";
    private static final String LOOM_GENERATED_MARKER = "fabric-loom:generated";
    private final Set<ModDescription> mods;
    private final Map<String, ModDescription> modsById;
    private final Map<String, ModDescription> rootMods = Mods.loadModDescriptions();

    private Mods() {
        this.mods = this.rootMods.values().stream().flatMap(ModDescription::selfAndChildren).collect(Collectors.toUnmodifiableSet());
        this.modsById = this.mods.stream().collect(Collectors.toUnmodifiableMap(ModDescription::modId, UnaryOperator.identity()));
    }

    public @Nullable ModDescription findMod(String modId) {
        return this.modsById.get(modId);
    }

    public int totalModCount() {
        return this.mods.size();
    }

    public int topLevelModCount() {
        return this.rootMods.size();
    }

    public Stream<ModDescription> allMods() {
        return this.mods.stream();
    }

    public Collection<ModDescription> topLevelMods() {
        return this.rootMods.values();
    }

    public static Mods mods() {
        return Holder.INSTANCE;
    }

    private static Map<String, ModDescription> loadModDescriptions() {
        FabricLoader loader = FabricLoader.getInstance();
        Set<String> hiddenModIds = ModsCommandModInitializer.instance().config().hiddenModIds();
        Map<String, ModDescription> descriptions = loader.getAllMods().stream().map(ModContainer::getMetadata).map(ModDescription::fromFabric).filter(mod -> !hiddenModIds.contains(mod.modId())).collect(Collectors.toMap(ModDescription::modId, UnaryOperator.identity()));
        Mods.arrangeQSLChildren(descriptions);
        Mods.arrangeQFapiChildren(descriptions);
        Mods.arrangeFapiChildren(descriptions);
        Mods.arrangeLoomGenerated(descriptions);
        Mods.arrangeChildModsUsingModMenuMetadata(descriptions);
        return ImmutableMap.builder().orderEntriesByValue(Comparator.comparing(ModDescription::modId)).putAll(descriptions).build();
    }

    private static void arrangeChildModsUsingModMenuMetadata(Map<String, ModDescription> descriptions) {
        HashMap<String, List> byParent = new HashMap<String, List>();
        descriptions.values().forEach(modDescription -> {
            @Nullable String parent = Mods.parentUsingModMenuMetadata(modDescription);
            if (parent == null) {
                return;
            }
            byParent.computeIfAbsent(parent, $ -> new ArrayList()).add(modDescription);
        });
        byParent.forEach((parentId, children) -> {
            @Nullable ModDescription parent = (ModDescription)descriptions.get(parentId);
            if (parent == null) {
                return;
            }
            for (ModDescription child : children) {
                descriptions.remove(child.modId());
                ((AbstractModDescription)parent).addChild(child);
            }
        });
    }

    private static void arrangeQSLChildren(Map<String, ModDescription> descriptions) {
        List<ModDescription> qslModules = Mods.findChildrenUsingModMenuMetadata(QSL_MOD_ID, descriptions);
        if (qslModules.isEmpty()) {
            return;
        }
        ModDescription qsl = descriptions.computeIfAbsent(QSL_MOD_ID, id -> ModDescription.create(qslModules, id, "Quilt Standard Libraries", "", "quilt", "A set of libraries to assist in making Quilt mods.", List.of("QuiltMC: QSL Team"), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Environment.UNIVERSAL));
        qslModules.forEach(module -> {
            descriptions.remove(module.modId());
            if (!qsl.children().contains(module)) {
                ((AbstractModDescription)qsl).addChild((ModDescription)module);
            }
        });
    }

    private static void arrangeQFapiChildren(Map<String, ModDescription> descriptions) {
        @Nullable ModDescription qfapi = descriptions.get(QUILTED_FABRIC_API_MOD_ID);
        if (qfapi != null) {
            List<ModDescription> qfapiModules = descriptions.values().stream().filter(it -> it.hasAttribute(ModMetadata.class) && it.attribute(ModMetadata.class).containsCustomValue(FABRIC_API_MODULE_MARKER) && it.modId().startsWith("quilted_")).toList();
            qfapiModules.forEach(module -> {
                descriptions.remove(module.modId());
                ((AbstractModDescription)qfapi).addChild((ModDescription)module);
            });
        }
    }

    private static void arrangeFapiChildren(Map<String, ModDescription> descriptions) {
        @Nullable ModDescription fapi = Mods.fabricApi(descriptions);
        if (fapi == null) {
            return;
        }
        List<ModDescription> fapiModules = descriptions.values().stream().filter(it -> it.hasAttribute(ModMetadata.class) && it.attribute(ModMetadata.class).containsCustomValue(FABRIC_API_MODULE_MARKER)).toList();
        fapiModules.forEach(module -> {
            descriptions.remove(module.modId());
            ((AbstractModDescription)fapi).addChild((ModDescription)module);
        });
    }

    private static @Nullable ModDescription fabricApi(Map<String, ModDescription> descriptions) {
        @Nullable ModDescription fapi = descriptions.get(FABRIC_API_MOD_ID);
        if (fapi == null) {
            fapi = descriptions.get(LEGACY_FABRIC_API_MOD_ID);
        }
        return fapi;
    }

    private static void arrangeLoomGenerated(Map<String, ModDescription> descriptions) {
        List<ModDescription> loomGeneratedMods = descriptions.values().stream().filter(it -> it.hasAttribute(ModMetadata.class) && it.attribute(ModMetadata.class).containsCustomValue(LOOM_GENERATED_MARKER)).toList();
        loomGeneratedMods.forEach(module -> descriptions.remove(module.modId()));
        if (!loomGeneratedMods.isEmpty()) {
            descriptions.put("loom-generated", ModDescription.create(loomGeneratedMods, "loom-generated", "Loom Generated", "", "category", "Parent mod to all Loom-generated library mods.", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Environment.UNIVERSAL));
        }
    }

    private static List<ModDescription> findChildrenUsingModMenuMetadata(String parentId, Map<String, ModDescription> descriptions) {
        return descriptions.values().stream().filter(description -> parentId.equals(Mods.parentUsingModMenuMetadata(description))).toList();
    }

    private static @Nullable String parentUsingModMenuMetadata(ModDescription modDescription) {
        if (!modDescription.hasAttribute(ModMetadata.class)) {
            return null;
        }
        ModMetadata meta = modDescription.attribute(ModMetadata.class);
        if (!meta.containsCustomValue("modmenu") || !meta.getCustomValue("modmenu").getAsObject().containsKey("parent")) {
            return null;
        }
        CustomValue parent = meta.getCustomValue("modmenu").getAsObject().get("parent");
        if (parent.getType() == CustomValue.CvType.STRING) {
            return parent.getAsString();
        }
        return parent.getAsObject().get("id").getAsString();
    }

    private static final class Holder {
        static final Mods INSTANCE = new Mods();

        private Holder() {
        }
    }
}

