/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.owasp.html;

import java.util.Map;
import squaremap.libraries.org.owasp.shim.Java8Shim;

public enum HtmlTextEscapingMode {
    PCDATA,
    CDATA,
    CDATA_SOMETIMES,
    RCDATA,
    PLAIN_TEXT,
    VOID;

    private static final Map<String, HtmlTextEscapingMode> ESCAPING_MODES;

    public static HtmlTextEscapingMode getModeForTag(String canonTagName) {
        HtmlTextEscapingMode mode = ESCAPING_MODES.get(canonTagName);
        return mode != null ? mode : PCDATA;
    }

    public static boolean isTagFollowedByLiteralContent(String canonTagName) {
        HtmlTextEscapingMode mode = HtmlTextEscapingMode.getModeForTag(canonTagName);
        return mode != PCDATA && mode != VOID;
    }

    public static boolean isVoidElement(String canonTagName) {
        return HtmlTextEscapingMode.getModeForTag(canonTagName) == VOID;
    }

    static {
        ESCAPING_MODES = Java8Shim.j8().mapOfEntries(Java8Shim.j8().mapEntry("iframe", CDATA), Java8Shim.j8().mapEntry("listing", CDATA_SOMETIMES), Java8Shim.j8().mapEntry("xmp", CDATA), Java8Shim.j8().mapEntry("comment", CDATA_SOMETIMES), Java8Shim.j8().mapEntry("plaintext", PLAIN_TEXT), Java8Shim.j8().mapEntry("script", CDATA), Java8Shim.j8().mapEntry("style", CDATA), Java8Shim.j8().mapEntry("textarea", RCDATA), Java8Shim.j8().mapEntry("title", RCDATA), Java8Shim.j8().mapEntry("area", VOID), Java8Shim.j8().mapEntry("base", VOID), Java8Shim.j8().mapEntry("br", VOID), Java8Shim.j8().mapEntry("col", VOID), Java8Shim.j8().mapEntry("command", VOID), Java8Shim.j8().mapEntry("embed", VOID), Java8Shim.j8().mapEntry("hr", VOID), Java8Shim.j8().mapEntry("img", VOID), Java8Shim.j8().mapEntry("input", VOID), Java8Shim.j8().mapEntry("keygen", VOID), Java8Shim.j8().mapEntry("link", VOID), Java8Shim.j8().mapEntry("meta", VOID), Java8Shim.j8().mapEntry("param", VOID), Java8Shim.j8().mapEntry("source", VOID), Java8Shim.j8().mapEntry("track", VOID), Java8Shim.j8().mapEntry("wbr", VOID), Java8Shim.j8().mapEntry("basefont", VOID), Java8Shim.j8().mapEntry("isindex", VOID));
    }
}

