/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.api.marker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.marker.Circle;
import xyz.jpenilla.squaremap.api.marker.Ellipse;
import xyz.jpenilla.squaremap.api.marker.Icon;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;
import xyz.jpenilla.squaremap.api.marker.MultiPolygon;
import xyz.jpenilla.squaremap.api.marker.Polygon;
import xyz.jpenilla.squaremap.api.marker.Polyline;
import xyz.jpenilla.squaremap.api.marker.Rectangle;

public abstract class Marker {
    private MarkerOptions markerOptions = MarkerOptions.defaultOptions();

    protected Marker() {
    }

    public final @NonNull MarkerOptions markerOptions() {
        return this.markerOptions;
    }

    public final @NonNull Marker markerOptions(@NonNull MarkerOptions markerOptions) {
        this.markerOptions = markerOptions;
        return this;
    }

    public final @NonNull Marker markerOptions(@NonNull MarkerOptions.Builder markerOptionsBuilder) {
        this.markerOptions(markerOptionsBuilder.build());
        return this;
    }

    public static @NonNull Polyline polyline(@NonNull List<Point> points) {
        return Marker.multiPolyline(new List[]{Collections.unmodifiableList(new ArrayList<Point>(points))});
    }

    public static @NonNull Polyline polyline(Point ... points) {
        return Marker.polyline(Arrays.asList(points));
    }

    public static @NonNull Polyline multiPolyline(@NonNull List<List<Point>> points) {
        return new Polyline(points);
    }

    @SafeVarargs
    public static @NonNull Polyline multiPolyline(List<Point> ... points) {
        return Marker.multiPolyline(Arrays.asList(points));
    }

    public static @NonNull Rectangle rectangle(@NonNull Point point1, @NonNull Point point2) {
        return new Rectangle(point1, point2);
    }

    public static @NonNull Circle circle(@NonNull Point center, double radius) {
        return new Circle(center, radius);
    }

    public static @NonNull Ellipse ellipse(@NonNull Point center, double radiusX, double radiusZ) {
        return new Ellipse(center, radiusX, radiusZ);
    }

    public static @NonNull Icon icon(@NonNull Point point, @NonNull Point tooltipAnchor, @NonNull Point anchor, @NonNull Key image, int sizeX, int sizeZ) {
        return new Icon(point, tooltipAnchor, anchor, image, sizeX, sizeZ);
    }

    public static @NonNull Icon icon(@NonNull Point point, @NonNull Key image, int sizeX, int sizeZ) {
        return Marker.icon(point, Point.of(0.0, (double)(-sizeZ) / 2.0), Point.of((double)sizeX / 2.0, (double)sizeZ / 2.0), image, sizeX, sizeZ);
    }

    public static @NonNull Icon icon(@NonNull Point point, @NonNull Key image, int size) {
        return Marker.icon(point, Point.of(0.0, (double)(-size) / 2.0), Point.of((double)size / 2.0, (double)size / 2.0), image, size, size);
    }

    public static @NonNull MultiPolygon multiPolygon(MultiPolygon.MultiPolygonPart ... polygons) {
        return Marker.multiPolygon(Arrays.asList(polygons));
    }

    public static @NonNull MultiPolygon multiPolygon(@NonNull List<MultiPolygon.MultiPolygonPart> polygons) {
        return new MultiPolygon(polygons);
    }

    public static @NonNull Polygon polygon(Point ... points) {
        return Marker.polygon(Arrays.asList(points));
    }

    public static @NonNull Polygon polygon(@NonNull List<Point> points) {
        return Marker.polygon(points, Collections.emptyList());
    }

    public static @NonNull Polygon polygon(@NonNull List<Point> mainPolygon, @NonNull List<List<Point>> negativeSpace) {
        return new Polygon(mainPolygon, negativeSpace);
    }

    @SafeVarargs
    public static @NonNull Polygon polygon(@NonNull List<Point> mainPolygon, List<Point> ... negativeSpace) {
        return Marker.polygon(mainPolygon, Arrays.asList(negativeSpace));
    }

    protected boolean markerOptionsMatch(Marker marker) {
        return this.markerOptions.equals(marker.markerOptions);
    }
}

