/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Singleton;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.ServerAccess;
import xyz.jpenilla.squaremap.common.WorldManager;
import xyz.jpenilla.squaremap.common.config.ConfigManager;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Util;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.EmptySectionHolder;

@DefaultQualifier(value=NonNull.class)
@Singleton
public class WorldManagerImpl
implements WorldManager {
    private final Map<WorldIdentifier, MapWorldInternal> worlds = new ConcurrentHashMap<WorldIdentifier, MapWorldInternal>();
    private final MapWorldInternal.Factory factory;
    protected final ServerAccess serverAccess;
    private final ConfigManager configManager;

    @Inject
    protected WorldManagerImpl(MapWorldInternal.Factory factory, ServerAccess serverAccess, ConfigManager configManager) {
        this.factory = factory;
        this.serverAccess = serverAccess;
        this.configManager = configManager;
    }

    @Override
    public Collection<MapWorldInternal> worlds() {
        return Collections.unmodifiableCollection(this.worlds.values());
    }

    @Override
    public Optional<MapWorldInternal> getWorldIfEnabled(WorldIdentifier worldIdentifier) {
        return Optional.ofNullable(this.worlds.get(worldIdentifier));
    }

    @Override
    public Optional<MapWorldInternal> getWorldIfEnabled(ServerLevel level) {
        return this.getWorldIfEnabled(Util.worldIdentifier(level));
    }

    public void initWorld(ServerLevel level) {
        EmptySectionHolder.init(level.palettedContainerFactory());
        WorldIdentifier identifier = Util.worldIdentifier(level);
        if (this.worlds.containsKey(identifier)) {
            throw new IllegalStateException("MapWorld already exists for '" + identifier.asString() + "'");
        }
        if (this.configManager.worldConfig((ServerLevel)level).MAP_ENABLED) {
            this.worlds.put(identifier, this.factory.create(level));
        }
    }

    public void start() {
        for (ServerLevel level : this.serverAccess.levels()) {
            this.initWorld(level);
        }
    }

    public void worldUnloaded(ServerLevel world) {
        @Nullable MapWorldInternal removed = this.worlds.remove(Util.worldIdentifier(world));
        if (removed != null) {
            WorldManagerImpl.tryShutdown(removed);
        }
    }

    public void shutdown() {
        List<MapWorldInternal> worlds = List.copyOf(this.worlds.values());
        this.worlds.clear();
        for (MapWorldInternal world : worlds) {
            WorldManagerImpl.tryShutdown(world);
        }
    }

    private static void tryShutdown(MapWorldInternal mapWorld) {
        try {
            mapWorld.shutdown();
        }
        catch (Exception ex) {
            Logging.logger().error("Exception shutting down map world '{}'", (Object)mapWorld.identifier().asString(), (Object)ex);
        }
    }
}

