/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.util.ComponentMessageThrowable;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.org.incendo.cloud.CommandManager;
import squaremap.libraries.org.incendo.cloud.exception.ArgumentParseException;
import squaremap.libraries.org.incendo.cloud.exception.CommandExecutionException;
import squaremap.libraries.org.incendo.cloud.exception.InvalidCommandSenderException;
import squaremap.libraries.org.incendo.cloud.exception.InvalidSyntaxException;
import squaremap.libraries.org.incendo.cloud.exception.NoPermissionException;
import squaremap.libraries.org.incendo.cloud.exception.handling.ExceptionContext;
import squaremap.libraries.org.incendo.cloud.exception.parsing.ParserException;
import squaremap.libraries.org.incendo.cloud.util.TypeUtils;
import squaremap.libraries.org.spongepowered.configurate.util.NamingSchemes;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.exception.CommandCompleted;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.util.Components;

@DefaultQualifier(value=NonNull.class)
final class ExceptionHandler {
    @Inject
    private ExceptionHandler() {
    }

    public void registerExceptionHandlers(CommandManager<Commander> manager) {
        manager.exceptionController().registerHandler(CommandExecutionException.class, this::commandExecution).registerHandler(CommandExecutionException.class, squaremap.libraries.org.incendo.cloud.exception.handling.ExceptionHandler.unwrappingHandler(CommandCompleted.class)).registerHandler(CommandCompleted.class, this::commandCompleted).registerHandler(NoPermissionException.class, this::noPermission).registerHandler(ArgumentParseException.class, this::argumentParsing).registerHandler(InvalidCommandSenderException.class, this::invalidSender).registerHandler(InvalidSyntaxException.class, this::invalidSyntax);
    }

    private void commandCompleted(ExceptionContext<Commander, CommandCompleted> ctx) {
        @Nullable Component message = ctx.exception().componentMessage();
        if (message != null) {
            ExceptionHandler.decorateAndSend(ctx.context().sender(), (ComponentLike)message);
        }
    }

    private void commandExecution(ExceptionContext<Commander, CommandExecutionException> ctx) {
        Throwable cause = ctx.exception().getCause();
        Logging.logger().warn("An unexpected error occurred during command execution", cause);
        TextComponent.Builder message = Component.text();
        message.append((ComponentLike)Messages.COMMAND_EXCEPTION_COMMAND_EXECUTION);
        if (ctx.context().sender().hasPermission("squaremap.command-exception-stacktrace")) {
            ExceptionHandler.decorateWithHoverStacktrace(message, cause);
        }
        ExceptionHandler.decorateAndSend(ctx.context().sender(), (ComponentLike)message);
    }

    private void noPermission(ExceptionContext<Commander, NoPermissionException> ctx) {
        ExceptionHandler.decorateAndSend(ctx.context().sender(), Messages.COMMAND_EXCEPTION_NO_PERMISSION);
    }

    private void argumentParsing(ExceptionContext<Commander, ArgumentParseException> ctx) {
        Component message;
        Throwable cause = ctx.exception().getCause();
        Supplier<Component> fallback = () -> Objects.requireNonNull(ExceptionHandler.componentMessage(cause));
        if (cause instanceof ParserException) {
            Component fromConfig;
            ParserException parserException = (ParserException)cause;
            TagResolver[] placeholders = (TagResolver[])Arrays.stream(parserException.captionVariables()).map(variable -> Components.placeholder(NamingSchemes.SNAKE_CASE.coerce(variable.key()), variable.value())).toArray(TagResolver[]::new);
            String key = "command.message.parser-exception." + parserException.errorCaption().key().replace("argument.parse.failure.", "");
            try {
                fromConfig = Messages.componentMessage(key).withPlaceholders(placeholders);
            }
            catch (Exception ex) {
                Logging.logger().warn("Could not get message with key '{}'", (Object)key, (Object)ex);
                fromConfig = null;
            }
            message = fromConfig != null ? fromConfig : fallback.get();
        } else {
            message = fallback.get();
        }
        ExceptionHandler.decorateAndSend(ctx.context().sender(), (ComponentLike)Messages.COMMAND_EXCEPTION_INVALID_ARGUMENT.withPlaceholders(new TagResolver[]{Components.placeholder("message", (ComponentLike)message)}));
    }

    private void invalidSender(ExceptionContext<Commander, InvalidCommandSenderException> ctx) {
        Component requiredSender = Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.text((String)" or ")), ctx.exception().requiredSenderTypes().stream().map(TypeUtils::simpleName).map(Component::text).toList());
        Component message = Messages.COMMAND_EXCEPTION_INVALID_SENDER_TYPE.withPlaceholders(new TagResolver[]{Components.placeholder("required_sender_type", (ComponentLike)requiredSender)});
        ExceptionHandler.decorateAndSend(ctx.context().sender(), (ComponentLike)message);
    }

    private void invalidSyntax(ExceptionContext<Commander, InvalidSyntaxException> ctx) {
        Component message = Messages.COMMAND_EXCEPTION_INVALID_SYNTAX.withPlaceholders(new TagResolver[]{Components.placeholder("correct_syntax", (ComponentLike)Components.highlightSpecialCharacters((Component)Component.text((String)"/%s".formatted(ctx.exception().correctSyntax())), (TextColor)NamedTextColor.WHITE))});
        ExceptionHandler.decorateAndSend(ctx.context().sender(), (ComponentLike)message);
    }

    private static void decorateAndSend(Audience audience, ComponentLike componentLike) {
        TextComponent message = Component.textOfChildren((ComponentLike[])new ComponentLike[]{Messages.COMMAND_PREFIX.asComponent().hoverEvent((HoverEventSource)Messages.CLICK_FOR_HELP.asComponent()).clickEvent(ClickEvent.runCommand((String)"/%s help".formatted(Config.MAIN_COMMAND_LABEL))), componentLike});
        audience.sendMessage((Component)message);
    }

    private static void decorateWithHoverStacktrace(TextComponent.Builder message, Throwable cause) {
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString().replaceAll("\t", "    ");
        TextComponent.Builder hoverText = Component.text();
        @Nullable Component throwableMessage = ExceptionHandler.componentMessage(cause);
        if (throwableMessage != null) {
            ((TextComponent.Builder)((TextComponent.Builder)hoverText.append(throwableMessage)).append((Component)Component.newline())).append((Component)Component.newline());
        }
        ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)hoverText.append((Component)Component.text((String)stackTrace))).append((Component)Component.newline())).append((Component)Component.text((String)"    "))).append(Messages.CLICK_TO_COPY.asComponent().color((TextColor)NamedTextColor.GRAY).decorate(TextDecoration.ITALIC));
        message.hoverEvent((HoverEventSource)hoverText.build());
        message.clickEvent(ClickEvent.copyToClipboard((String)stackTrace));
    }

    private static @Nullable Component componentMessage(Throwable cause) {
        if (cause instanceof ComponentMessageThrowable || !(cause instanceof CommandSyntaxException)) {
            return ComponentMessageThrowable.getOrConvertMessage((Throwable)cause);
        }
        CommandSyntaxException commandSyntaxException = (CommandSyntaxException)cause;
        net.minecraft.network.chat.Component component = ComponentUtils.fromMessage((Message)commandSyntaxException.getRawMessage());
        return GsonComponentSerializer.gson().deserializeFromTree((JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)component).getOrThrow(JsonParseException::new));
    }
}

