/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.data;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.server.level.ServerLevel;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Singleton;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.inject.annotation.DataDirectory;
import xyz.jpenilla.squaremap.common.util.Util;

@DefaultQualifier(value=NonNull.class)
@Singleton
public final class DirectoryProvider {
    private final Path dataDirectory;
    private final Path localeDirectory;
    private @MonotonicNonNull Path webDirectory;
    private @MonotonicNonNull Path tilesDirectory;

    @Inject
    private DirectoryProvider(@DataDirectory Path dataDirectory) {
        this.dataDirectory = dataDirectory;
        this.localeDirectory = dataDirectory.resolve("locale");
    }

    public void init() {
        this.webDirectory = this.dataDirectory.resolve(Config.WEB_DIR);
        this.tilesDirectory = this.webDirectory.resolve("tiles");
    }

    public Path dataDirectory() {
        return this.dataDirectory;
    }

    public Path webDirectory() {
        return this.webDirectory;
    }

    public Path tilesDirectory() {
        return this.tilesDirectory;
    }

    public Path localeDirectory() {
        return this.localeDirectory;
    }

    public Path getAndCreateDataDirectory(ServerLevel level) {
        Path data = this.dataDirectory().resolve("data").resolve(Util.levelWebName(level));
        try {
            if (!Files.exists(data, new LinkOption[0])) {
                Files.createDirectories(data, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            Logging.error(Messages.LOG_COULD_NOT_CREATE_DIR, new IllegalStateException("Failed to create data directory for world '%s'".formatted(level.dimension().identifier()), ex), "path", data.toAbsolutePath());
        }
        return data;
    }

    public Path getAndCreateTilesDirectory(ServerLevel level) {
        Path dir = this.tilesDirectory.resolve(Util.levelWebName(level));
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            Logging.error(Messages.LOG_COULD_NOT_CREATE_DIR, new IllegalStateException("Failed to create tiles directory for world '%s'".formatted(level.dimension().identifier()), ex), "path", dir.toAbsolutePath());
        }
        return dir;
    }
}

