/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.httpd;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Singleton;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.util.FileUtil;

@DefaultQualifier(value=NonNull.class)
@Singleton
public final class JsonCache {
    private final DirectoryProvider directoryProvider;
    private final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();

    @Inject
    private JsonCache(DirectoryProvider directoryProvider) {
        this.directoryProvider = directoryProvider;
    }

    boolean handle(HttpServerExchange exchange) {
        @Nullable CacheEntry cached = this.cache.get(exchange.getRelativePath());
        if (cached == null) {
            return false;
        }
        String timestamp = String.valueOf(cached.timestamp);
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        exchange.getResponseHeaders().put(Headers.ETAG, timestamp);
        String requestedEtag = exchange.getRequestHeaders().getFirst(Headers.IF_NONE_MATCH);
        if (requestedEtag != null && requestedEtag.equals(timestamp)) {
            exchange.setStatusCode(304);
            exchange.endExchange();
            return true;
        }
        exchange.getResponseSender().send(cached.data);
        return true;
    }

    public void put(String path, @Nullable String json) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(path);
        }
        this.cache.compute(path, (pathKey, existing) -> {
            if (json == null) {
                return null;
            }
            if (existing != null && existing.data.equals(json)) {
                return existing;
            }
            CacheEntry entry = CacheEntry.create(json);
            if (Config.FLUSH_JSON_IMMEDIATELY || !Config.HTTPD_ENABLED) {
                this.write(path, json);
            }
            return entry;
        });
    }

    public void flush() {
        this.cache.forEach((path, entry) -> this.write((String)path, entry.data));
    }

    public void clear() {
        this.cache.clear();
    }

    private void write(String path, String data) {
        try {
            FileUtil.atomicWrite(this.directoryProvider.webDirectory().resolve("." + path), tmp -> Files.writeString(tmp, (CharSequence)data, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private record CacheEntry(String data, long timestamp) {
        static CacheEntry create(String data) {
            return new CacheEntry(data, System.currentTimeMillis());
        }
    }
}

