/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.httpd;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.util.Util;

public final class ViteRunner
extends Thread {
    private static final AtomicInteger COUNT = new AtomicInteger(0);
    private final ThreadFactory threadFactory;
    private final Path dir;
    private final CompletableFuture<String> url = new CompletableFuture();
    private volatile boolean running = true;

    public ViteRunner(String frontendPath) {
        this.dir = Path.of(frontendPath, new String[0]);
        this.setName("squaremap-vite-runner-" + COUNT.getAndIncrement());
        this.threadFactory = Thread.ofVirtual().name(this.getName() + "-", 0L).factory();
    }

    @Override
    public void run() {
        Logging.logger().info("Starting Vite dev server...");
        try {
            String line;
            int idx;
            Process process = new ProcessBuilder(new String[0]).directory(this.dir.toFile()).command("bun", "run", "dev").redirectErrorStream(true).start();
            do {
                if ((line = this.readLine(process)) == null) {
                    throw new RuntimeException("Vite dev server process exited before URL was found");
                }
                Logging.info(line, new Object[0]);
            } while ((idx = line.indexOf("http://localhost:")) == -1);
            String foundUrl = line.substring(idx).trim();
            if (foundUrl.endsWith("/")) {
                foundUrl = foundUrl.substring(0, foundUrl.length() - 1);
            }
            this.url.complete(foundUrl);
            while (this.running && (line = this.readLine(process)) != null) {
                Logging.info(line, new Object[0]);
            }
            process.destroy();
            try {
                if (!process.waitFor(4L, TimeUnit.SECONDS)) {
                    process.destroyForcibly();
                }
            }
            catch (InterruptedException e) {
                process.destroyForcibly();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception running Vite dev server", e);
        }
    }

    private String readLine(Process process) {
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
            try {
                return process.inputReader().readLine();
            }
            catch (IOException e) {
                throw Util.rethrow(e);
            }
        }, task -> this.threadFactory.newThread(task).start());
        while (!future.isDone()) {
            boolean interrupted = Thread.interrupted();
            Thread.yield();
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(50L));
            if (!interrupted) continue;
            return null;
        }
        return future.join();
    }

    void shutdown() {
        Logging.logger().info("Shutting down Vite dev server...");
        this.running = false;
        this.interrupt();
        try {
            if (this.join(Duration.ofSeconds(5L))) {
                Logging.info("Vite dev server shut down", new Object[0]);
            } else {
                Logging.logger().error("Vite dev server did not shut down in time, you may need to kill it manually");
            }
        }
        catch (InterruptedException e) {
            Logging.error("Error shutting down Vite dev server", e, new Object[0]);
        }
    }

    CompletableFuture<String> getUrl() {
        return this.url;
    }
}

