/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import net.minecraft.world.level.material.MapColor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class Colors {
    private Colors() {
    }

    public static int removeAlpha(int color) {
        return 0xFF000000 | color & 0xFFFFFF;
    }

    public static int shade(int color, int shade) {
        float ratio = switch (shade) {
            case 0 -> 0.7058824f;
            case 1 -> 0.8627451f;
            case 2 -> 1.0f;
            default -> throw new IllegalStateException("Unexpected shade: " + shade);
        };
        return Colors.shade(color, ratio);
    }

    public static int shade(int color, float ratio) {
        int r = (int)((float)(color >> 16 & 0xFF) * ratio);
        int g = (int)((float)(color >> 8 & 0xFF) * ratio);
        int b = (int)((float)(color & 0xFF) * ratio);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int abgrToArgb(int abgr) {
        int a = abgr >> 24 & 0xFF;
        int r = abgr & 0xFF;
        int g = abgr >> 8 & 0xFF;
        int b = abgr >> 16 & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int argbToRgba(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return r << 24 | g << 16 | b << 8 | a;
    }

    public static int rgbaToArgb(int color) {
        int r = color >> 24 & 0xFF;
        int g = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int a = color & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int mix(int c1, int c2, float ratio) {
        if (ratio >= 1.0f) {
            return c2;
        }
        if (ratio <= 0.0f) {
            return c1;
        }
        float iRatio = 1.0f - ratio;
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int plantMapColor() {
        return Colors.rgb(MapColor.PLANT);
    }

    public static int clearMapColor() {
        return Colors.rgb(MapColor.NONE);
    }

    public static int parseHex(String color) {
        int rgba = (int)Long.parseLong(color.replace("#", ""), 16);
        if (color.length() == 9) {
            return Colors.rgbaToArgb(rgba);
        }
        return rgba;
    }

    public static int rgb(MapColor color) {
        return color.col;
    }

    public static String toHexString(int color) {
        return String.format("#%08X", color);
    }
}

