/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util.chunksnapshot;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.common.util.ChunkMapAccess;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshot;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshotProvider;

@DefaultQualifier(value=NonNull.class)
record VanillaChunkSnapshotProvider(ServerLevel level, boolean moonrise) implements ChunkSnapshotProvider
{
    private static final Identifier FULL = BuiltInRegistries.CHUNK_STATUS.getKey((Object)ChunkStatus.FULL);

    private Executor mainThreadExecutor() {
        return task -> {
            if (this.level.getServer().isSameThread()) {
                task.run();
                return;
            }
            this.level.getServer().execute(task);
        };
    }

    @Override
    public CompletableFuture<@Nullable ChunkSnapshot> asyncSnapshot(int x, int z) {
        if (this.moonrise) {
            return this.moonriseAsyncSnapshot(x, z);
        }
        return CompletableFuture.supplyAsync(() -> {
            @Nullable ChunkAccess chunk = VanillaChunkSnapshotProvider.chunkIfGenerated(this.level, x, z);
            if (chunk == null) {
                return null;
            }
            return ChunkSnapshot.snapshot((Level)this.level, chunk, false);
        }, this.mainThreadExecutor());
    }

    private CompletableFuture<@Nullable ChunkSnapshot> moonriseAsyncSnapshot(int x, int z) {
        return CompletableFuture.supplyAsync(() -> {
            ChunkAccess chunk2;
            ChunkMapAccess chunkMap = (ChunkMapAccess)this.level.getChunkSource().chunkMap;
            ChunkPos chunkPos = new ChunkPos(x, z);
            ChunkHolder visibleChunk = chunkMap.squaremap$getVisibleChunkIfPresent(chunkPos.toLong());
            if (visibleChunk != null && (chunk2 = VanillaChunkSnapshotProvider.fullIfPresent(visibleChunk)) != null) {
                return CompletableFuture.completedFuture(ChunkSnapshot.snapshot((Level)this.level, chunk2, false));
            }
            CompletableFuture<@Nullable T> load = new CompletableFuture();
            PlatformHooks.get().scheduleChunkLoad(this.level, x, z, ChunkStatus.EMPTY, true, Priority.NORMAL, chunk -> {
                @Nullable ChunkAccess unwrap = VanillaChunkSnapshotProvider.unwrap(chunk);
                if (unwrap != null) {
                    load.complete(ChunkSnapshot.snapshot((Level)this.level, unwrap, false));
                } else {
                    load.complete(null);
                }
            });
            return load;
        }, this.mainThreadExecutor()).thenCompose(future -> future);
    }

    private static @Nullable ChunkAccess chunkIfGenerated(ServerLevel level, int x, int z) {
        ChunkAccess chunk;
        ChunkAccess chunk2;
        ChunkMapAccess chunkMap = (ChunkMapAccess)level.getChunkSource().chunkMap;
        ChunkPos chunkPos = new ChunkPos(x, z);
        ChunkHolder visibleChunk = chunkMap.squaremap$getVisibleChunkIfPresent(chunkPos.toLong());
        if (visibleChunk != null && (chunk2 = VanillaChunkSnapshotProvider.fullIfPresent(visibleChunk)) != null) {
            return chunk2;
        }
        ChunkHolder unloadingChunk = (ChunkHolder)chunkMap.squaremap$pendingUnloads().get(chunkPos.toLong());
        if (unloadingChunk != null && (chunk = VanillaChunkSnapshotProvider.fullIfPresent(unloadingChunk)) != null) {
            return chunk;
        }
        @Nullable CompoundTag chunkTag = chunkMap.squaremap$readChunk(chunkPos).join().orElse(null);
        if (chunkTag != null && chunkTag.contains("Status") && (VanillaChunkSnapshotProvider.isFullStatus(chunkTag) || VanillaChunkSnapshotProvider.preHeightChangeFullChunk(chunkTag))) {
            @Nullable ChunkAccess chunk3 = (ChunkAccess)((ChunkResult)level.getChunkSource().getChunkFuture(x, z, ChunkStatus.EMPTY, true).join()).orElse(null);
            return VanillaChunkSnapshotProvider.unwrap(chunk3);
        }
        return null;
    }

    private static boolean isFullStatus(CompoundTag chunkTag) {
        return FULL.equals((Object)Identifier.tryParse((String)((String)chunkTag.getString("Status").orElseThrow())));
    }

    private static @Nullable ChunkAccess fullIfPresent(ChunkHolder chunkHolder) {
        return VanillaChunkSnapshotProvider.unwrap(chunkHolder.getLatestChunk());
    }

    private static @Nullable ChunkAccess unwrap(@Nullable ChunkAccess chunk) {
        if (chunk == null) {
            return null;
        }
        if (chunk instanceof ImposterProtoChunk) {
            ImposterProtoChunk imposter = (ImposterProtoChunk)chunk;
            chunk = imposter.getWrapped();
        }
        if (!chunk.getPersistedStatus().isOrAfter(ChunkStatus.FULL) && !VanillaChunkSnapshotProvider.preHeightChangeFullChunk(chunk)) {
            return null;
        }
        return chunk;
    }

    private static boolean preHeightChangeFullChunk(ChunkAccess chunk) {
        return chunk.getBelowZeroRetrogen() != null && chunk.getBelowZeroRetrogen().targetStatus().isOrAfter(ChunkStatus.SPAWN);
    }

    private static boolean preHeightChangeFullChunk(CompoundTag chunkTag) {
        CompoundTag belowZeroRetrogen = chunkTag.getCompoundOrEmpty("below_zero_retrogen");
        if (belowZeroRetrogen.isEmpty()) {
            return false;
        }
        String targetStatusStr = belowZeroRetrogen.getStringOr("target_status", "");
        if (targetStatusStr.isEmpty()) {
            return false;
        }
        @Nullable Identifier targetStatus = Identifier.tryParse((String)targetStatusStr);
        if (targetStatus == null) {
            return false;
        }
        return ((ChunkStatus)BuiltInRegistries.CHUNK_STATUS.getValue(targetStatus)).isOrAfter(ChunkStatus.SPAWN);
    }
}

