/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.visibilitylimit;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.border.WorldBorder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Numbers;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityShape;

@DefaultQualifier(value=NonNull.class)
public final class WorldBorderShape
implements VisibilityShape {
    @Override
    public boolean shouldRenderChunk(MapWorld world, int chunkX, int chunkZ) {
        WorldBorder border = ((MapWorldInternal)world).serverLevel().getWorldBorder();
        BlockPos center = new BlockPos((int)border.getCenterX(), 0, (int)border.getCenterZ());
        int radius = (int)Math.ceil(border.getSize() / 2.0);
        if (chunkX < Numbers.blockToChunk(center.getX() - radius) || chunkX > Numbers.blockToChunk(center.getX() + radius)) {
            return false;
        }
        return chunkZ >= Numbers.blockToChunk(center.getZ() - radius) && chunkZ <= Numbers.blockToChunk(center.getZ() + radius);
    }

    @Override
    public boolean shouldRenderRegion(MapWorld world, int regionX, int regionZ) {
        WorldBorder border = ((MapWorldInternal)world).serverLevel().getWorldBorder();
        BlockPos center = new BlockPos((int)border.getCenterX(), 0, (int)border.getCenterZ());
        int radius = (int)Math.ceil(border.getSize() / 2.0);
        if (regionX < Numbers.blockToRegion(center.getX() - radius) || regionX > Numbers.blockToRegion(center.getX() + radius)) {
            return false;
        }
        return regionZ >= Numbers.blockToRegion(center.getZ() - radius) && regionZ <= Numbers.blockToRegion(center.getZ() + radius);
    }

    @Override
    public boolean shouldRenderColumn(MapWorld world, int blockX, int blockZ) {
        WorldBorder border = ((MapWorldInternal)world).serverLevel().getWorldBorder();
        BlockPos center = new BlockPos((int)border.getCenterX(), 0, (int)border.getCenterZ());
        int radius = (int)Math.ceil(border.getSize() / 2.0);
        if (blockX < center.getX() - radius || blockX >= center.getX() + radius) {
            return false;
        }
        return blockZ >= center.getZ() - radius && blockZ < center.getZ() + radius;
    }

    @Override
    public int countChunksInRegion(MapWorld world, int regionX, int regionZ) {
        WorldBorder border = ((MapWorldInternal)world).serverLevel().getWorldBorder();
        int regionMinChunkX = Numbers.regionToChunk(regionX);
        int regionMaxChunkX = Numbers.regionToChunk(regionX + 1) - 1;
        int regionMinChunkZ = Numbers.regionToChunk(regionZ);
        int regionMaxChunkZ = Numbers.regionToChunk(regionZ + 1) - 1;
        BlockPos center = new BlockPos((int)border.getCenterX(), 0, (int)border.getCenterZ());
        int radius = (int)Math.ceil(border.getSize() / 2.0);
        int borderMinChunkX = Numbers.blockToChunk(center.getX() - radius);
        int borderMaxChunkX = Numbers.blockToChunk(center.getX() + radius);
        int borderMinChunkZ = Numbers.blockToChunk(center.getZ() - radius);
        int borderMaxChunkZ = Numbers.blockToChunk(center.getZ() + radius);
        int chunkWidth = Math.min(regionMaxChunkX, borderMaxChunkX) - Math.max(regionMinChunkX, borderMinChunkX) + 1;
        int chunkHeight = Math.min(regionMaxChunkZ, borderMaxChunkZ) - Math.max(regionMinChunkZ, borderMinChunkZ) + 1;
        if (chunkWidth < 0 || chunkHeight < 0) {
            return 0;
        }
        return chunkWidth * chunkHeight;
    }
}

