/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.network;

import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.map.MapRenderer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.network.NetworkingHandler;
import xyz.jpenilla.squaremap.paper.util.CraftBukkitHelper;

@DefaultQualifier(value=NonNull.class)
public final class PaperNetworking
implements Listener {
    private final JavaPlugin plugin;
    private final Server server;
    private final NetworkingHandler networking;

    @Inject
    private PaperNetworking(JavaPlugin plugin, Server server, NetworkingHandler networking) {
        this.plugin = plugin;
        this.server = server;
        this.networking = networking;
    }

    public void register() {
        this.server.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.server.getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, NetworkingHandler.CHANNEL.toString(), this::handlePluginMessage);
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
        this.server.getMessenger().unregisterIncomingPluginChannel((Plugin)this.plugin, NetworkingHandler.CHANNEL.toString());
    }

    private void handlePluginMessage(String channel, Player player, byte[] data) {
        this.networking.handleIncoming(CraftBukkitHelper.serverPlayer(player), data, PaperNetworking::isVanillaMap);
    }

    @EventHandler
    public void handlePlayerQuit(PlayerQuitEvent event) {
        this.networking.onDisconnect(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void handlePlayerChangedWorld(PlayerChangedWorldEvent event) {
        this.networking.worldChanged(CraftBukkitHelper.serverPlayer(event.getPlayer()));
    }

    private static boolean isVanillaMap(MapItemSavedData mapData) {
        for (MapRenderer renderer : mapData.mapView.getRenderers()) {
            if (renderer.getClass().getSimpleName().equals("CraftMapRenderer")) continue;
            return false;
        }
        return true;
    }
}

