/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.owasp.html;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import squaremap.libraries.org.owasp.html.AttributePolicy;
import squaremap.libraries.org.owasp.html.Strings;
import squaremap.libraries.org.owasp.html.TCB;

@TCB
public class FilterUrlByProtocolAttributePolicy
implements AttributePolicy {
    private final Set<String> protocols;
    private static String[] CONTROL_REPL = new String[]{"", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20"};

    public FilterUrlByProtocolAttributePolicy(Iterable<? extends String> protocols) {
        HashSet builder = new HashSet();
        protocols.forEach(builder::add);
        this.protocols = Collections.unmodifiableSet(builder);
    }

    @Override
    @Nullable
    public String apply(String elementName, String attributeName, String value) {
        String url = Strings.stripHtmlSpaces(value);
        int n = url.length();
        block4: for (int i = 0; i < n; ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    if (!url.startsWith("//") || this.allowProtocolRelativeUrls()) break block4;
                    return null;
                }
                case ':': {
                    String protocol = Strings.toLowerCase(url.substring(0, i));
                    if (this.protocols.contains(protocol)) break block4;
                    return null;
                }
                default: {
                    continue block4;
                }
            }
        }
        return FilterUrlByProtocolAttributePolicy.normalizeUri(url);
    }

    protected boolean allowProtocolRelativeUrls() {
        return this.protocols.contains("http") && this.protocols.contains("https");
    }

    static String normalizeUri(String s) {
        int n = s.length();
        boolean colonsIrrelevant = false;
        block5: for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '#': 
                case '/': 
                case ':': 
                case '?': {
                    colonsIrrelevant = true;
                    continue block5;
                }
                case '(': 
                case ')': 
                case '{': 
                case '}': {
                    return FilterUrlByProtocolAttributePolicy.normalizeUriFrom(s, i, colonsIrrelevant);
                }
                case '\u0589': 
                case '\u05c3': 
                case '\u2236': 
                case '\uff1a': {
                    if (colonsIrrelevant) continue block5;
                    return FilterUrlByProtocolAttributePolicy.normalizeUriFrom(s, i, false);
                }
                default: {
                    if (ch > ' ') continue block5;
                    return FilterUrlByProtocolAttributePolicy.normalizeUriFrom(s, i, false);
                }
            }
        }
        return s;
    }

    private static String normalizeUriFrom(String s, int start, boolean colonsIrrelevant) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n + 16);
        int pos = 0;
        for (int i = start; i < n; ++i) {
            char ch = s.charAt(i);
            String repl = null;
            switch (ch) {
                case '(': {
                    repl = "%28";
                    break;
                }
                case ')': {
                    repl = "%29";
                    break;
                }
                case '{': {
                    repl = "%7b";
                    break;
                }
                case '}': {
                    repl = "%7d";
                    break;
                }
                default: {
                    if (ch >= '\u0100' && !colonsIrrelevant) {
                        switch (ch) {
                            case '\u0589': {
                                repl = "%d6%89";
                                break;
                            }
                            case '\u05c3': {
                                repl = "%d7%83";
                                break;
                            }
                            case '\u2236': {
                                repl = "%e2%88%b6";
                                break;
                            }
                            case '\uff1a': {
                                repl = "%ef%bc%9a";
                            }
                        }
                        break;
                    }
                    if (ch > ' ') break;
                    repl = CONTROL_REPL[ch];
                }
            }
            if (repl == null) continue;
            sb.append(s, pos, i).append(repl);
            pos = i + 1;
        }
        return sb.append(s, pos, n).toString();
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.protocols.equals(((FilterUrlByProtocolAttributePolicy)o).protocols);
    }

    public int hashCode() {
        return this.protocols.hashCode();
    }
}

