/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.owasp.shim;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import squaremap.libraries.org.owasp.shim.Java8Shim;

class ForJava8
extends Java8Shim {
    ForJava8() {
    }

    @Override
    public <T> List<T> listOf() {
        return ImmutableListShim.empty();
    }

    @Override
    public <T> List<T> listOf(T a) {
        return new ImmutableListShim<T>(Collections.singletonList(a));
    }

    @Override
    public <T> List<T> listOf(T a, T b) {
        ArrayList<T> ls = new ArrayList<T>(2);
        ls.add(a);
        ls.add(b);
        return new ImmutableListShim(ls);
    }

    @Override
    public <T> List<T> listOf(T a, T b, T c) {
        ArrayList<T> ls = new ArrayList<T>(3);
        ls.add(a);
        ls.add(b);
        ls.add(c);
        return new ImmutableListShim(ls);
    }

    @Override
    public <T> List<T> listOf(T ... els) {
        return new ImmutableListShim<T>(Arrays.asList(els));
    }

    @Override
    public <T> List<T> listCopyOf(Collection<? extends T> c) {
        if (c instanceof ImmutableListShim) {
            return (ImmutableListShim)c;
        }
        return new ImmutableListShim<T>(new ArrayList<T>(c));
    }

    @Override
    public <K, V> Map<K, V> mapCopyOf(Map<? extends K, ? extends V> m) {
        if (m instanceof ImmutableMapShim) {
            return (ImmutableMapShim)m;
        }
        return new ImmutableMapShim<K, V>(new LinkedHashMap<K, V>(m));
    }

    @Override
    public <K, V> Map.Entry<K, V> mapEntry(K key, V value) {
        return new ImmutableEntryShim<K, V>(key, value);
    }

    @Override
    public <K, V> Map<K, V> mapOfEntries(Map.Entry<K, V> ... entries) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>(entries.length);
        for (Map.Entry<K, V> e : entries) {
            m.put(e.getKey(), e.getValue());
        }
        return new ImmutableMapShim(m);
    }

    @Override
    public <T> Set<T> setOf() {
        return new ImmutableSetShim(Collections.emptySet());
    }

    @Override
    public <T> Set<T> setOf(T a) {
        return new ImmutableSetShim<T>(Collections.singleton(a));
    }

    @Override
    public <T> Set<T> setOf(T a, T b) {
        LinkedHashSet<T> ls = new LinkedHashSet<T>(2);
        ls.add(a);
        ls.add(b);
        return new ImmutableSetShim(ls);
    }

    @Override
    public <T> Set<T> setOf(T a, T b, T c) {
        LinkedHashSet<T> ls = new LinkedHashSet<T>(3);
        ls.add(a);
        ls.add(b);
        ls.add(c);
        return new ImmutableSetShim(ls);
    }

    @Override
    public <T> Set<T> setOf(T ... els) {
        return new ImmutableSetShim<T>(new LinkedHashSet<T>(Arrays.asList(els)));
    }

    @Override
    public <T> Set<T> setCopyOf(Collection<? extends T> c) {
        if (c instanceof ImmutableSetShim) {
            return (ImmutableSetShim)c;
        }
        return new ImmutableSetShim<T>(new LinkedHashSet<T>(c));
    }

    private static final class ImmutableSetShim<T>
    extends AbstractSet<T> {
        private final Set<T> underlying;

        ImmutableSetShim(Set<T> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Iterator<T> iterator() {
            class IteratorImpl
            implements Iterator<T> {
                private final Iterator<T> underlying;

                IteratorImpl(Iterator<T> underlying) {
                    this.underlying = underlying;
                }

                @Override
                public boolean hasNext() {
                    return this.underlying.hasNext();
                }

                @Override
                public T next() {
                    return this.underlying.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new IteratorImpl(this.underlying.iterator());
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }
    }

    private static final class ImmutableEntryShim<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        ImmutableEntryShim(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ImmutableEntrySetShim<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<K, V>> underlying;

        ImmutableEntrySetShim(Set<Map.Entry<K, V>> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            class IteratorImpl
            implements Iterator<Map.Entry<K, V>> {
                private final Iterator<Map.Entry<K, V>> underlying;
                private ImmutableEntryShim<K, V> pending;

                IteratorImpl(Iterator<Map.Entry<K, V>> underlying) {
                    this.underlying = underlying;
                }

                @Override
                public boolean hasNext() {
                    if (this.pending == null && this.underlying.hasNext()) {
                        Map.Entry e = this.underlying.next();
                        this.pending = new ImmutableEntryShim(e.getKey(), e.getValue());
                    }
                    return this.pending != null;
                }

                @Override
                public Map.Entry<K, V> next() {
                    ImmutableEntryShim next = this.pending;
                    this.pending = null;
                    if (next == null) {
                        throw new NoSuchElementException();
                    }
                    return next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new IteratorImpl(this.underlying.iterator());
        }

        @Override
        public int size() {
            return this.underlying.size();
        }
    }

    private static final class ImmutableMapShim<K, V>
    extends AbstractMap<K, V> {
        private final Map<K, V> underlying;

        ImmutableMapShim(Map<K, V> underlying) {
            this.underlying = underlying;
        }

        @Override
        public V get(Object k) {
            return this.underlying.get(k);
        }

        @Override
        public boolean containsKey(Object k) {
            return this.underlying.containsKey(k);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new ImmutableEntrySetShim<K, V>(this.underlying.entrySet());
        }
    }

    private static final class ImmutableListShim<T>
    extends AbstractList<T> {
        private final List<T> underlying;
        private static final ImmutableListShim<Object> empty = new ImmutableListShim(Collections.emptyList());

        ImmutableListShim(List<T> underlying) {
            this.underlying = underlying;
        }

        @Override
        public T get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        static <T> ImmutableListShim<T> empty() {
            return empty;
        }
    }
}

